/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util.concurrent;

import com.datastax.oss.driver.internal.core.util.concurrent.CycleDetector;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class LazyReference<T> {
    private final String name;
    private final Supplier<T> supplier;
    private final CycleDetector checker;
    private volatile T value;
    private ReentrantLock lock = new ReentrantLock();

    public LazyReference(String name, Supplier<T> supplier, CycleDetector cycleDetector) {
        this.name = name;
        this.supplier = supplier;
        this.checker = cycleDetector;
    }

    public T get() {
        T t = this.value;
        if (t == null) {
            this.checker.onTryLock(this);
            this.lock.lock();
            try {
                this.checker.onLockAcquired(this);
                t = this.value;
                if (t == null) {
                    this.value = t = this.supplier.get();
                }
            }
            finally {
                this.checker.onReleaseLock(this);
                this.lock.unlock();
            }
        }
        return t;
    }

    public String getName() {
        return this.name;
    }
}

