/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.BatchableStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.protocol.internal.FrameCodec;
import com.datastax.oss.protocol.internal.PrimitiveSizes;
import com.datastax.oss.protocol.internal.request.query.QueryOptions;
import com.datastax.oss.protocol.internal.request.query.Values;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Sizes {
    public static int minimumRequestSize(Request request) {
        int size = FrameCodec.headerEncodedSize();
        if (!request.getCustomPayload().isEmpty()) {
            size += PrimitiveSizes.sizeOfBytesMap(request.getCustomPayload());
        }
        return size;
    }

    public static int minimumStatementSize(Statement statement, DriverContext context) {
        int size = Sizes.minimumRequestSize(statement);
        size += QueryOptions.queryFlagsSize((int)context.getProtocolVersion().getCode());
        size += 2;
        return size += 2;
    }

    public static int sizeOfSimpleStatementValues(SimpleStatement simpleStatement, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        int size = 0;
        if (!simpleStatement.getPositionalValues().isEmpty()) {
            ArrayList<ByteBuffer> positionalValues = new ArrayList<ByteBuffer>(simpleStatement.getPositionalValues().size());
            for (Object value : simpleStatement.getPositionalValues()) {
                positionalValues.add(Conversions.encode(value, codecRegistry, protocolVersion));
            }
            size += Values.sizeOfPositionalValues(positionalValues);
        } else if (!simpleStatement.getNamedValues().isEmpty()) {
            HashMap<String, ByteBuffer> namedValues = new HashMap<String, ByteBuffer>(simpleStatement.getNamedValues().size());
            for (Map.Entry<CqlIdentifier, Object> value : simpleStatement.getNamedValues().entrySet()) {
                namedValues.put(value.getKey().asInternal(), Conversions.encode(value.getValue(), codecRegistry, protocolVersion));
            }
            size += Values.sizeOfNamedValues(namedValues);
        }
        return size;
    }

    public static int sizeOfBoundStatementValues(BoundStatement boundStatement) {
        return Values.sizeOfPositionalValues(boundStatement.getValues());
    }

    public static Integer sizeOfInnerBatchStatementInBytes(BatchableStatement statement, ProtocolVersion protocolVersion, CodecRegistry codecRegistry) {
        int size = 0;
        ++size;
        if (statement instanceof SimpleStatement) {
            size += PrimitiveSizes.sizeOfLongString((String)((SimpleStatement)statement).getQuery());
            size += Sizes.sizeOfSimpleStatementValues((SimpleStatement)statement, protocolVersion, codecRegistry);
        } else if (statement instanceof BoundStatement) {
            size += PrimitiveSizes.sizeOfShortBytes((byte[])((BoundStatement)statement).getPreparedStatement().getId().array());
            size += Sizes.sizeOfBoundStatementValues((BoundStatement)statement);
        }
        return size;
    }
}

