/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.tracker;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.tracker.RequestLogFormatter;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class RequestLogger
implements RequestTracker {
    private static final Logger LOG = LoggerFactory.getLogger(RequestLogger.class);
    public static final int DEFAULT_REQUEST_LOGGER_MAX_QUERY_LENGTH = 500;
    public static final boolean DEFAULT_REQUEST_LOGGER_SHOW_VALUES = true;
    public static final int DEFAULT_REQUEST_LOGGER_MAX_VALUES = 50;
    public static final int DEFAULT_REQUEST_LOGGER_MAX_VALUE_LENGTH = 50;
    private final String logPrefix;
    private final RequestLogFormatter formatter;

    public RequestLogger(DriverContext context) {
        this(context.getSessionName(), new RequestLogFormatter(context));
    }

    protected RequestLogger(String logPrefix, RequestLogFormatter formatter) {
        this.logPrefix = logPrefix;
        this.formatter = formatter;
    }

    @Override
    public void onSuccess(@NonNull Request request, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node) {
        boolean isSlow;
        boolean successEnabled = executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOGGER_SUCCESS_ENABLED, false);
        boolean slowEnabled = executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOGGER_SLOW_ENABLED, false);
        if (!successEnabled && !slowEnabled) {
            return;
        }
        long slowThresholdNanos = executionProfile.getDuration(DefaultDriverOption.REQUEST_LOGGER_SLOW_THRESHOLD, Duration.ofSeconds(1L)).toNanos();
        boolean bl = isSlow = latencyNanos > slowThresholdNanos;
        if (isSlow && !slowEnabled || !isSlow && !successEnabled) {
            return;
        }
        int maxQueryLength = executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_QUERY_LENGTH, 500);
        boolean showValues = executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOGGER_VALUES, true);
        int maxValues = executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUES, 50);
        int maxValueLength = executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUE_LENGTH, 50);
        this.logSuccess(request, latencyNanos, isSlow, node, maxQueryLength, showValues, maxValues, maxValueLength);
    }

    @Override
    public void onError(@NonNull Request request, @NonNull Throwable error, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, Node node) {
        if (!executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOGGER_ERROR_ENABLED, false)) {
            return;
        }
        int maxQueryLength = executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_QUERY_LENGTH, 500);
        boolean showValues = executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOGGER_VALUES, true);
        int maxValues = executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUES, 50);
        int maxValueLength = executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUE_LENGTH, 50);
        boolean showStackTraces = executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOGGER_STACK_TRACES, false);
        this.logError(request, error, latencyNanos, node, maxQueryLength, showValues, maxValues, maxValueLength, showStackTraces);
    }

    @Override
    public void onNodeError(@NonNull Request request, @NonNull Throwable error, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node) {
    }

    @Override
    public void onNodeSuccess(@NonNull Request request, long latencyNanos, @NonNull DriverExecutionProfile executionProfile, @NonNull Node node) {
    }

    @Override
    public void close() throws Exception {
    }

    protected void logSuccess(Request request, long latencyNanos, boolean isSlow, Node node, int maxQueryLength, boolean showValues, int maxValues, int maxValueLength) {
        StringBuilder builder = this.formatter.logBuilder(this.logPrefix, node);
        if (isSlow) {
            this.formatter.appendSlowDescription(builder);
        } else {
            this.formatter.appendSuccessDescription(builder);
        }
        this.formatter.appendLatency(latencyNanos, builder);
        this.formatter.appendRequest(request, maxQueryLength, showValues, maxValues, maxValueLength, builder);
        LOG.info(builder.toString());
    }

    protected void logError(Request request, Throwable error, long latencyNanos, Node node, int maxQueryLength, boolean showValues, int maxValues, int maxValueLength, boolean showStackTraces) {
        StringBuilder builder = this.formatter.logBuilder(this.logPrefix, node);
        this.formatter.appendErrorDescription(builder);
        this.formatter.appendLatency(latencyNanos, builder);
        this.formatter.appendRequest(request, maxQueryLength, showValues, maxValues, maxValueLength, builder);
        if (showStackTraces) {
            LOG.error(builder.toString(), error);
        } else {
            LOG.error("{} [{}]", (Object)builder.toString(), (Object)error.toString());
        }
    }
}

