/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.token.LocalReplicationStrategy;
import com.datastax.oss.driver.internal.core.metadata.token.NetworkTopologyReplicationStrategy;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategy;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.SimpleReplicationStrategy;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DefaultReplicationStrategyFactory
implements ReplicationStrategyFactory {
    private final String logPrefix;

    public DefaultReplicationStrategyFactory(InternalDriverContext context) {
        this.logPrefix = context.getSessionName();
    }

    @Override
    public ReplicationStrategy newInstance(Map<String, String> replicationConfig) {
        String strategyClass = replicationConfig.get("class");
        Preconditions.checkNotNull((Object)strategyClass, (Object)("Missing replication strategy class in " + replicationConfig));
        switch (strategyClass) {
            case "org.apache.cassandra.locator.LocalStrategy": {
                return new LocalReplicationStrategy();
            }
            case "org.apache.cassandra.locator.SimpleStrategy": {
                return new SimpleReplicationStrategy(replicationConfig);
            }
            case "org.apache.cassandra.locator.NetworkTopologyStrategy": {
                return new NetworkTopologyReplicationStrategy(replicationConfig, this.logPrefix);
            }
        }
        throw new IllegalArgumentException("Unsupported replication strategy: " + strategyClass);
    }
}

