/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.ShallowUserDefinedType;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.internal.core.type.DefaultTupleType;
import com.datastax.oss.driver.internal.core.type.codec.ParseUtils;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class DataTypeCqlNameParser
implements DataTypeParser {
    @VisibleForTesting
    static final ImmutableMap<String, DataType> NATIVE_TYPES_BY_NAME = new ImmutableMap.Builder().put((Object)"ascii", (Object)DataTypes.ASCII).put((Object)"bigint", (Object)DataTypes.BIGINT).put((Object)"blob", (Object)DataTypes.BLOB).put((Object)"boolean", (Object)DataTypes.BOOLEAN).put((Object)"counter", (Object)DataTypes.COUNTER).put((Object)"decimal", (Object)DataTypes.DECIMAL).put((Object)"double", (Object)DataTypes.DOUBLE).put((Object)"float", (Object)DataTypes.FLOAT).put((Object)"inet", (Object)DataTypes.INET).put((Object)"int", (Object)DataTypes.INT).put((Object)"text", (Object)DataTypes.TEXT).put((Object)"varchar", (Object)DataTypes.TEXT).put((Object)"timestamp", (Object)DataTypes.TIMESTAMP).put((Object)"date", (Object)DataTypes.DATE).put((Object)"time", (Object)DataTypes.TIME).put((Object)"uuid", (Object)DataTypes.UUID).put((Object)"varint", (Object)DataTypes.VARINT).put((Object)"timeuuid", (Object)DataTypes.TIMEUUID).put((Object)"tinyint", (Object)DataTypes.TINYINT).put((Object)"smallint", (Object)DataTypes.SMALLINT).put((Object)"duration", (Object)DataTypes.DURATION).build();

    @Override
    public DataType parse(CqlIdentifier keyspaceId, String toParse, Map<CqlIdentifier, UserDefinedType> userTypes, InternalDriverContext context) {
        return this.parse(toParse, keyspaceId, false, userTypes, context);
    }

    private DataType parse(String toParse, CqlIdentifier keyspaceId, boolean frozen, Map<CqlIdentifier, UserDefinedType> userTypes, InternalDriverContext context) {
        if (toParse.startsWith("'")) {
            return DataTypes.custom(toParse.substring(1, toParse.length() - 1));
        }
        Parser parser = new Parser(toParse, 0);
        String type = parser.parseTypeName();
        DataType nativeType = (DataType)NATIVE_TYPES_BY_NAME.get((Object)type.toLowerCase());
        if (nativeType != null) {
            return nativeType;
        }
        if (type.equalsIgnoreCase("list")) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 1) {
                throw new IllegalArgumentException(String.format("Expecting single parameter for list, got %s", parameters));
            }
            DataType elementType = this.parse(parameters.get(0), keyspaceId, false, userTypes, context);
            return DataTypes.listOf(elementType, frozen);
        }
        if (type.equalsIgnoreCase("set")) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 1) {
                throw new IllegalArgumentException(String.format("Expecting single parameter for set, got %s", parameters));
            }
            DataType elementType = this.parse(parameters.get(0), keyspaceId, false, userTypes, context);
            return DataTypes.setOf(elementType, frozen);
        }
        if (type.equalsIgnoreCase("map")) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 2) {
                throw new IllegalArgumentException(String.format("Expecting two parameters for map, got %s", parameters));
            }
            DataType keyType = this.parse(parameters.get(0), keyspaceId, false, userTypes, context);
            DataType valueType = this.parse(parameters.get(1), keyspaceId, false, userTypes, context);
            return DataTypes.mapOf(keyType, valueType, frozen);
        }
        if (type.equalsIgnoreCase("frozen")) {
            List<String> parameters = parser.parseTypeParameters();
            if (parameters.size() != 1) {
                throw new IllegalArgumentException(String.format("Expecting single parameter for frozen keyword, got %s", parameters));
            }
            return this.parse(parameters.get(0), keyspaceId, true, userTypes, context);
        }
        if (type.equalsIgnoreCase("tuple")) {
            List<String> rawTypes = parser.parseTypeParameters();
            ImmutableList.Builder componentTypesBuilder = ImmutableList.builder();
            for (String rawType : rawTypes) {
                componentTypesBuilder.add((Object)this.parse(rawType, keyspaceId, false, userTypes, context));
            }
            return new DefaultTupleType((List<DataType>)componentTypesBuilder.build(), context);
        }
        CqlIdentifier name = CqlIdentifier.fromCql(type);
        if (userTypes != null) {
            UserDefinedType userType = userTypes.get(name);
            if (userType == null) {
                throw new IllegalStateException(String.format("Can't find referenced user type %s", type));
            }
            return userType.copy(frozen);
        }
        return new ShallowUserDefinedType(keyspaceId, name, frozen);
    }

    private static class Parser {
        private final String str;
        private int idx;

        Parser(String str, int idx) {
            this.str = str;
            this.idx = idx;
        }

        String parseTypeName() {
            this.idx = ParseUtils.skipSpaces(this.str, this.idx);
            return this.readNextIdentifier();
        }

        List<String> parseTypeParameters() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.isEOS()) {
                return list;
            }
            this.skipBlankAndComma();
            if (this.str.charAt(this.idx) != '<') {
                throw new IllegalStateException();
            }
            ++this.idx;
            while (this.skipBlankAndComma()) {
                if (this.str.charAt(this.idx) == '>') {
                    ++this.idx;
                    return list;
                }
                String name = this.parseTypeName();
                String args = this.readRawTypeParameters();
                list.add(name + args);
            }
            throw new IllegalArgumentException(String.format("Syntax error parsing '%s' at char %d: unexpected end of string", this.str, this.idx));
        }

        private String readNextIdentifier() {
            int startIdx;
            if (this.str.charAt(startIdx = this.idx++) == '\"') {
                while (!this.isEOS()) {
                    boolean atQuote = this.str.charAt(this.idx) == '\"';
                    ++this.idx;
                    if (!atQuote) continue;
                    if (!this.isEOS() && this.str.charAt(this.idx) == '\"') {
                        ++this.idx;
                        continue;
                    }
                    break;
                }
            } else if (this.str.charAt(startIdx) == '\'') {
                ++this.idx;
                while (!this.isEOS() && this.str.charAt(this.idx++) != '\'') {
                }
            } else {
                while (!this.isEOS() && (ParseUtils.isCqlIdentifierChar(this.str.charAt(this.idx)) || this.str.charAt(this.idx) == '\"')) {
                    ++this.idx;
                }
            }
            return this.str.substring(startIdx, this.idx);
        }

        private String readRawTypeParameters() {
            this.idx = ParseUtils.skipSpaces(this.str, this.idx);
            if (this.isEOS() || this.str.charAt(this.idx) == '>' || this.str.charAt(this.idx) == ',') {
                return "";
            }
            if (this.str.charAt(this.idx) != '<') {
                throw new IllegalStateException(String.format("Expecting char %d of %s to be '<' but '%c' found", this.idx, this.str, Character.valueOf(this.str.charAt(this.idx))));
            }
            int i = this.idx;
            int open = 1;
            boolean inQuotes = false;
            while (open > 0) {
                ++this.idx;
                if (this.isEOS()) {
                    throw new IllegalStateException("Non closed angle brackets");
                }
                if (!inQuotes) {
                    if (this.str.charAt(this.idx) == '\"') {
                        inQuotes = true;
                        continue;
                    }
                    if (this.str.charAt(this.idx) == '<') {
                        ++open;
                        continue;
                    }
                    if (this.str.charAt(this.idx) != '>') continue;
                    --open;
                    continue;
                }
                if (this.str.charAt(this.idx) != '\"') continue;
                inQuotes = false;
            }
            ++this.idx;
            return this.str.substring(i, this.idx);
        }

        private boolean skipBlankAndComma() {
            boolean commaFound = false;
            while (!this.isEOS()) {
                char c = this.str.charAt(this.idx);
                if (c == ',') {
                    if (commaFound) {
                        return true;
                    }
                    commaFound = true;
                } else if (!ParseUtils.isBlank(c)) {
                    return true;
                }
                ++this.idx;
            }
            return false;
        }

        private boolean isEOS() {
            return this.idx >= this.str.length();
        }

        public String toString() {
            return this.str.substring(0, this.idx) + "[" + (this.idx == this.str.length() ? "" : Character.valueOf(this.str.charAt(this.idx))) + "]" + this.str.substring(this.idx + 1);
        }
    }
}

