/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRequestHandler;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.adminrequest.UnexpectedResponseException;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultNodeInfo;
import com.datastax.oss.driver.internal.core.metadata.NodeInfo;
import com.datastax.oss.driver.internal.core.metadata.SchemaAgreementChecker;
import com.datastax.oss.driver.internal.core.metadata.TopologyMonitor;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.response.Error;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class DefaultTopologyMonitor
implements TopologyMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultTopologyMonitor.class);
    private static final int INFINITE_PAGE_SIZE = -1;
    private final String logPrefix;
    private final InternalDriverContext context;
    private final ControlConnection controlConnection;
    private final AddressTranslator addressTranslator;
    private final Duration timeout;
    private final boolean reconnectOnInit;
    private final CompletableFuture<Void> closeFuture;
    @VisibleForTesting
    volatile boolean isSchemaV2;
    @VisibleForTesting
    volatile int port = -1;

    public DefaultTopologyMonitor(InternalDriverContext context) {
        this.logPrefix = context.getSessionName();
        this.context = context;
        this.controlConnection = context.getControlConnection();
        this.addressTranslator = context.getAddressTranslator();
        DriverExecutionProfile config = context.getConfig().getDefaultProfile();
        this.timeout = config.getDuration(DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT);
        this.reconnectOnInit = config.getBoolean(DefaultDriverOption.RECONNECT_ON_INIT);
        this.closeFuture = new CompletableFuture();
        this.isSchemaV2 = true;
    }

    @Override
    public CompletionStage<Void> init() {
        if (this.closeFuture.isDone()) {
            return CompletableFutures.failedFuture(new IllegalStateException("closed"));
        }
        return this.controlConnection.init(true, this.reconnectOnInit, true);
    }

    @Override
    public CompletionStage<Void> initFuture() {
        return this.controlConnection.initFuture();
    }

    @Override
    public CompletionStage<Optional<NodeInfo>> refreshNode(Node node) {
        if (this.closeFuture.isDone()) {
            return CompletableFutures.failedFuture(new IllegalStateException("closed"));
        }
        LOG.debug("[{}] Refreshing info for {}", (Object)this.logPrefix, (Object)node);
        DriverChannel channel = this.controlConnection.channel();
        if (node.getEndPoint().equals(channel.getEndPoint())) {
            LOG.debug("[{}] Ignoring refresh of control node", (Object)this.logPrefix);
            return CompletableFuture.completedFuture(Optional.empty());
        }
        if (node.getBroadcastAddress().isPresent()) {
            CompletionStage<AdminResult> query = this.isSchemaV2 ? this.query(channel, "SELECT * FROM " + this.retrievePeerTableName() + " WHERE peer = :address and peer_port = :port", (Map<String, Object>)ImmutableMap.of((Object)"address", (Object)node.getBroadcastAddress().get().getAddress(), (Object)"peer", (Object)node.getBroadcastAddress().get().getPort())) : this.query(channel, "SELECT * FROM " + this.retrievePeerTableName() + " WHERE peer = :address", (Map<String, Object>)ImmutableMap.of((Object)"address", (Object)node.getBroadcastAddress().get().getAddress()));
            return query.thenApply(this::firstRowAsNodeInfo);
        }
        return this.query(channel, "SELECT * FROM " + this.retrievePeerTableName()).thenApply(result -> this.findInPeers((AdminResult)result, node.getHostId()));
    }

    @Override
    public CompletionStage<Optional<NodeInfo>> getNewNodeInfo(InetSocketAddress broadcastRpcAddress) {
        if (this.closeFuture.isDone()) {
            return CompletableFutures.failedFuture(new IllegalStateException("closed"));
        }
        LOG.debug("[{}] Fetching info for new node {}", (Object)this.logPrefix, (Object)broadcastRpcAddress);
        DriverChannel channel = this.controlConnection.channel();
        return this.query(channel, "SELECT * FROM " + this.retrievePeerTableName()).thenApply(result -> this.findInPeers((AdminResult)result, broadcastRpcAddress));
    }

    @Override
    public CompletionStage<Iterable<NodeInfo>> refreshNodeList() {
        if (this.closeFuture.isDone()) {
            return CompletableFutures.failedFuture(new IllegalStateException("closed"));
        }
        LOG.debug("[{}] Refreshing node list", (Object)this.logPrefix);
        DriverChannel channel = this.controlConnection.channel();
        InetSocketAddress controlBroadcastRpcAddress = (InetSocketAddress)channel.getEndPoint().resolve();
        this.savePort(channel);
        CompletionStage<AdminResult> localQuery = this.query(channel, "SELECT * FROM system.local");
        CompletionStage<AdminResult> peersV2Query = this.query(channel, "SELECT * FROM system.peers_v2");
        CompletableFuture peersQuery = new CompletableFuture();
        peersV2Query.whenComplete((r, t) -> {
            if (t != null) {
                if (t instanceof UnexpectedResponseException && ((UnexpectedResponseException)t).message instanceof Error) {
                    Error error = (Error)((UnexpectedResponseException)t).message;
                    if (error.code == 8704 || error.code == 0 && error.message.contains("Unknown keyspace/cf pair (system.peers_v2)")) {
                        this.isSchemaV2 = false;
                        CompletableFutures.completeFrom(this.query(channel, "SELECT * FROM system.peers"), peersQuery);
                        return;
                    }
                }
                peersQuery.completeExceptionally((Throwable)t);
            } else {
                peersQuery.complete(r);
            }
        });
        return localQuery.thenCombine(peersQuery, (controlNodeResult, peersResult) -> {
            ArrayList<NodeInfo> nodeInfos = new ArrayList<NodeInfo>();
            nodeInfos.add(this.nodeInfoBuilder(controlNodeResult.iterator().next(), controlBroadcastRpcAddress).build());
            for (AdminRow row : peersResult) {
                nodeInfos.add(this.asNodeInfo(row));
            }
            return nodeInfos;
        });
    }

    @Override
    public CompletionStage<Boolean> checkSchemaAgreement() {
        if (this.closeFuture.isDone()) {
            return CompletableFuture.completedFuture(true);
        }
        DriverChannel channel = this.controlConnection.channel();
        return new SchemaAgreementChecker(channel, this.context, this.port, this.logPrefix).run();
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeFuture() {
        return this.closeFuture;
    }

    @Override
    @NonNull
    public CompletionStage<Void> closeAsync() {
        this.closeFuture.complete(null);
        return this.closeFuture;
    }

    @Override
    @NonNull
    public CompletionStage<Void> forceCloseAsync() {
        return this.closeAsync();
    }

    @VisibleForTesting
    protected CompletionStage<AdminResult> query(DriverChannel channel, String queryString, Map<String, Object> parameters) {
        return AdminRequestHandler.query(channel, queryString, parameters, this.timeout, -1, this.logPrefix).start();
    }

    private CompletionStage<AdminResult> query(DriverChannel channel, String queryString) {
        return this.query(channel, queryString, Collections.emptyMap());
    }

    private String retrievePeerTableName() {
        if (this.isSchemaV2) {
            return "system.peers_v2";
        }
        return "system.peers";
    }

    private NodeInfo asNodeInfo(AdminRow row) {
        return this.nodeInfoBuilder(row, this.getBroadcastRpcAddress(row)).build();
    }

    private Optional<NodeInfo> firstRowAsNodeInfo(AdminResult result) {
        Iterator<AdminRow> iterator = result.iterator();
        if (iterator.hasNext()) {
            return Optional.of(this.asNodeInfo(iterator.next()));
        }
        return Optional.empty();
    }

    protected DefaultNodeInfo.Builder nodeInfoBuilder(AdminRow row, InetSocketAddress broadcastRpcAddress) {
        DefaultEndPoint endPoint = new DefaultEndPoint(this.context.getAddressTranslator().translate(broadcastRpcAddress));
        DefaultNodeInfo.Builder builder = DefaultNodeInfo.builder().withEndPoint(endPoint).withBroadcastRpcAddress(broadcastRpcAddress);
        InetAddress broadcastAddress = row.getInetAddress("broadcast_address");
        if (broadcastAddress == null) {
            broadcastAddress = row.getInetAddress("peer");
        }
        int broadcastPort = 0;
        if (row.contains("peer_port")) {
            broadcastPort = row.getInteger("peer_port");
        }
        builder.withBroadcastAddress(new InetSocketAddress(broadcastAddress, broadcastPort));
        InetAddress listenAddress = row.getInetAddress("listen_address");
        int listen_port = 0;
        if (row.contains("listen_port")) {
            listen_port = row.getInteger("listen_port");
        }
        builder.withListenAddress(new InetSocketAddress(listenAddress, listen_port));
        builder.withDatacenter(row.getString("data_center"));
        builder.withRack(row.getString("rack"));
        builder.withCassandraVersion(row.getString("release_version"));
        builder.withTokens(row.getSetOfString("tokens"));
        builder.withPartitioner(row.getString("partitioner"));
        builder.withHostId(row.getUuid("host_id"));
        builder.withSchemaVersion(row.getUuid("schema_version"));
        return builder;
    }

    private Optional<NodeInfo> findInPeers(AdminResult result, InetSocketAddress broadcastRpcAddressToFind) {
        for (AdminRow row : result) {
            InetSocketAddress broadcastRpcAddress = this.getBroadcastRpcAddress(row);
            if (broadcastRpcAddress == null || !broadcastRpcAddress.equals(broadcastRpcAddressToFind)) continue;
            return Optional.of(this.nodeInfoBuilder(row, broadcastRpcAddress).build());
        }
        LOG.debug("[{}] Could not find any peer row matching {}", (Object)this.logPrefix, (Object)broadcastRpcAddressToFind);
        return Optional.empty();
    }

    private Optional<NodeInfo> findInPeers(AdminResult result, UUID hostIdToFind) {
        for (AdminRow row : result) {
            UUID hostId = row.getUuid("host_id");
            if (hostId == null || !hostId.equals(hostIdToFind)) continue;
            return Optional.of(this.nodeInfoBuilder(row, this.getBroadcastRpcAddress(row)).build());
        }
        LOG.debug("[{}] Could not find any peer row matching {}", (Object)this.logPrefix, (Object)hostIdToFind);
        return Optional.empty();
    }

    private void savePort(DriverChannel channel) {
        SocketAddress address;
        if (this.port < 0 && (address = channel.getEndPoint().resolve()) instanceof InetSocketAddress) {
            this.port = ((InetSocketAddress)address).getPort();
        }
    }

    private InetSocketAddress getBroadcastRpcAddress(AdminRow row) {
        InetAddress nativeAddress = row.getInetAddress("native_address");
        if (nativeAddress == null) {
            InetAddress rpcAddress = row.getInetAddress("rpc_address");
            if (rpcAddress == null) {
                return null;
            }
            return new InetSocketAddress(rpcAddress, this.port);
        }
        Integer rowPort = row.getInteger("native_port");
        if (rowPort == null || rowPort == 0) {
            rowPort = this.port;
        }
        return new InetSocketAddress(nativeAddress, (int)rowPort);
    }
}

