/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.adminrequest;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.shaded.guava.common.annotations.VisibleForTesting;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.jcip.annotations.Immutable;

@Immutable
public class AdminRow {
    @VisibleForTesting
    static final TypeCodec<List<String>> LIST_OF_TEXT = TypeCodecs.listOf(TypeCodecs.TEXT);
    private static final TypeCodec<Set<String>> SET_OF_TEXT = TypeCodecs.setOf(TypeCodecs.TEXT);
    private static final TypeCodec<Map<String, String>> MAP_OF_STRING_TO_STRING = TypeCodecs.mapOf(TypeCodecs.TEXT, TypeCodecs.TEXT);
    private final Map<String, ColumnSpec> columnSpecs;
    private final List<ByteBuffer> data;
    private final ProtocolVersion protocolVersion;

    public AdminRow(Map<String, ColumnSpec> columnSpecs, List<ByteBuffer> data, ProtocolVersion protocolVersion) {
        this.columnSpecs = columnSpecs;
        this.data = data;
        this.protocolVersion = protocolVersion;
    }

    public Boolean getBoolean(String columnName) {
        return this.get(columnName, TypeCodecs.BOOLEAN);
    }

    public Integer getInteger(String columnName) {
        return this.get(columnName, TypeCodecs.INT);
    }

    public boolean isString(String columnName) {
        return this.columnSpecs.get((Object)columnName).type.id == 13;
    }

    public String getString(String columnName) {
        return this.get(columnName, TypeCodecs.TEXT);
    }

    public UUID getUuid(String columnName) {
        return this.get(columnName, TypeCodecs.UUID);
    }

    public ByteBuffer getByteBuffer(String columnName) {
        return this.get(columnName, TypeCodecs.BLOB);
    }

    public InetAddress getInetAddress(String columnName) {
        return this.get(columnName, TypeCodecs.INET);
    }

    public List<String> getListOfString(String columnName) {
        return this.get(columnName, LIST_OF_TEXT);
    }

    public Set<String> getSetOfString(String columnName) {
        return this.get(columnName, SET_OF_TEXT);
    }

    public Map<String, String> getMapOfStringToString(String columnName) {
        return this.get(columnName, MAP_OF_STRING_TO_STRING);
    }

    public boolean contains(String columnName) {
        return this.columnSpecs.containsKey(columnName);
    }

    public <T> T get(String columnName, TypeCodec<T> codec) {
        if (!this.contains(columnName)) {
            return null;
        }
        int index = this.columnSpecs.get((Object)columnName).index;
        return codec.decode(this.data.get(index), this.protocolVersion);
    }
}

