/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.UnsupportedProtocolVersionException;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.DefaultProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.shaded.guava.common.base.Preconditions;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CassandraProtocolVersionRegistry
implements ProtocolVersionRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraProtocolVersionRegistry.class);
    private static final ImmutableList<ProtocolVersion> values = ImmutableList.builder().add((Object[])DefaultProtocolVersion.values()).build();
    private final String logPrefix;
    private final NavigableMap<Integer, ProtocolVersion> versionsByCode;

    public CassandraProtocolVersionRegistry(String logPrefix) {
        this(logPrefix, new ProtocolVersion[][]{DefaultProtocolVersion.values()});
    }

    protected CassandraProtocolVersionRegistry(String logPrefix, ProtocolVersion[] ... versionRanges) {
        this.logPrefix = logPrefix;
        this.versionsByCode = this.byCode(versionRanges);
    }

    @Override
    public ProtocolVersion fromCode(int code) {
        ProtocolVersion protocolVersion = (ProtocolVersion)this.versionsByCode.get(code);
        if (protocolVersion == null) {
            throw new IllegalArgumentException("Unknown protocol version code: " + code);
        }
        return protocolVersion;
    }

    @Override
    public ProtocolVersion fromName(String name) {
        for (ProtocolVersion version : this.versionsByCode.values()) {
            if (!version.name().equals(name)) continue;
            return version;
        }
        throw new IllegalArgumentException("Unknown protocol version name: " + name);
    }

    @Override
    public ProtocolVersion highestNonBeta() {
        ProtocolVersion highest = this.versionsByCode.lastEntry().getValue();
        if (!highest.isBeta()) {
            return highest;
        }
        return this.downgrade(highest).orElseThrow(() -> new AssertionError((Object)"There should be at least one non-beta version"));
    }

    @Override
    public Optional<ProtocolVersion> downgrade(ProtocolVersion version) {
        Map.Entry<Integer, ProtocolVersion> previousEntry = this.versionsByCode.lowerEntry(version.getCode());
        if (previousEntry == null) {
            return Optional.empty();
        }
        ProtocolVersion previousVersion = previousEntry.getValue();
        return previousVersion.isBeta() ? this.downgrade(previousVersion) : Optional.of(previousVersion);
    }

    @Override
    public ProtocolVersion highestCommon(Collection<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("Expected at least one node");
        }
        TreeSet<DefaultProtocolVersion> candidates = new TreeSet<DefaultProtocolVersion>();
        for (DefaultProtocolVersion version : DefaultProtocolVersion.values()) {
            if (version.isBeta()) continue;
            candidates.add(version);
        }
        for (Node node : nodes) {
            Version version = node.getCassandraVersion();
            if (version == null) {
                LOG.warn("[{}] Node {} reports null Cassandra version, ignoring it from optimal protocol version computation", (Object)this.logPrefix, (Object)node.getEndPoint());
                continue;
            }
            if ((version = version.nextStable()).compareTo(Version.V2_1_0) < 0) {
                throw new UnsupportedProtocolVersionException(node.getEndPoint(), String.format("Node %s reports Cassandra version %s, but the driver only supports 2.1.0 and above", node.getEndPoint(), version), (List<ProtocolVersion>)ImmutableList.of((Object)DefaultProtocolVersion.V3, (Object)DefaultProtocolVersion.V4));
            }
            LOG.debug("[{}] Node {} reports Cassandra version {}", new Object[]{this.logPrefix, node.getEndPoint(), version});
            if (version.compareTo(Version.V2_2_0) >= 0 || !candidates.remove(DefaultProtocolVersion.V4)) continue;
            LOG.debug("[{}] Excluding protocol V4", (Object)this.logPrefix);
        }
        if (candidates.isEmpty()) {
            throw new UnsupportedProtocolVersionException(null, String.format("Could not determine a common protocol version, enable DEBUG logs for '%s' for more details", LOG.getName()), (List<ProtocolVersion>)ImmutableList.of((Object)DefaultProtocolVersion.V3, (Object)DefaultProtocolVersion.V4));
        }
        return (ProtocolVersion)candidates.last();
    }

    @Override
    public boolean supports(ProtocolVersion version, ProtocolFeature feature) {
        if (DefaultProtocolFeature.UNSET_BOUND_VALUES.equals(feature)) {
            return version.getCode() >= 4;
        }
        if (DefaultProtocolFeature.PER_REQUEST_KEYSPACE.equals(feature)) {
            return version.getCode() >= 5;
        }
        throw new IllegalArgumentException("Unhandled protocol feature: " + feature);
    }

    public ImmutableList<ProtocolVersion> getValues() {
        return values;
    }

    private NavigableMap<Integer, ProtocolVersion> byCode(ProtocolVersion[][] versionRanges) {
        TreeMap<Integer, ProtocolVersion> map = new TreeMap<Integer, ProtocolVersion>();
        ProtocolVersion[][] protocolVersionArray = versionRanges;
        int n = protocolVersionArray.length;
        for (int i = 0; i < n; ++i) {
            ProtocolVersion[] versionRange;
            for (ProtocolVersion version : versionRange = protocolVersionArray[i]) {
                ProtocolVersion previous = map.put(version.getCode(), version);
                Preconditions.checkArgument((previous == null ? 1 : 0) != 0, (String)"Duplicate version code: %s in %s and %s", (Object)version.getCode(), (Object)previous, (Object)version);
            }
        }
        return map;
    }
}

