/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.dse.driver.internal.core.graph.DefaultAsyncGraphResultSet;
import com.datastax.dse.driver.internal.core.graph.GraphConversions;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.dse.driver.internal.core.graph.GraphSupportChecker;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.DriverException;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.RequestThrottlingException;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.connection.FrameTooLongException;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.DefaultSessionMetric;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryVerdict;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.FunctionFailureException;
import com.datastax.oss.driver.api.core.servererrors.ProtocolError;
import com.datastax.oss.driver.api.core.servererrors.QueryValidationException;
import com.datastax.oss.driver.api.core.servererrors.ReadTimeoutException;
import com.datastax.oss.driver.api.core.servererrors.UnavailableException;
import com.datastax.oss.driver.api.core.servererrors.WriteTimeoutException;
import com.datastax.oss.driver.api.core.session.throttling.RequestThrottler;
import com.datastax.oss.driver.api.core.session.throttling.Throttled;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.internal.core.cql.DefaultExecutionInfo;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.session.DefaultSession;
import com.datastax.oss.driver.internal.core.tracker.NoopRequestTracker;
import com.datastax.oss.driver.internal.core.util.Loggers;
import com.datastax.oss.driver.internal.core.util.collection.SimpleQueryPlan;
import com.datastax.oss.driver.shaded.netty.handler.codec.EncoderException;
import com.datastax.oss.driver.shaded.netty.util.Timeout;
import com.datastax.oss.driver.shaded.netty.util.Timer;
import com.datastax.oss.driver.shaded.netty.util.concurrent.Future;
import com.datastax.oss.driver.shaded.netty.util.concurrent.GenericFutureListener;
import com.datastax.oss.protocol.internal.Frame;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.datastax.oss.protocol.internal.response.Result;
import com.datastax.oss.protocol.internal.response.result.Rows;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GraphRequestHandler
implements Throttled {
    private static final Logger LOG = LoggerFactory.getLogger(GraphRequestHandler.class);
    private static final long NANOTIME_NOT_MEASURED_YET = -1L;
    private static final int NO_SUCCESSFUL_EXECUTION = -1;
    private final long startTimeNanos = System.nanoTime();
    private final String logPrefix;
    private final GraphStatement<?> initialStatement;
    private final DefaultSession session;
    private final InternalDriverContext context;
    protected final CompletableFuture<AsyncGraphResultSet> result;
    private final Timer timer;
    private final AtomicInteger activeExecutionsCount;
    private final AtomicInteger startedSpeculativeExecutionsCount;
    private final Timeout scheduledTimeout;
    private final List<Timeout> scheduledExecutions;
    private final List<NodeResponseCallback> inFlightCallbacks;
    private final RequestThrottler throttler;
    private final RequestTracker requestTracker;
    private final SessionMetricUpdater sessionMetricUpdater;
    private final GraphBinaryModule graphBinaryModule;
    private final GraphSupportChecker graphSupportChecker;
    private volatile List<Map.Entry<Node, Throwable>> errors;

    GraphRequestHandler(@NonNull GraphStatement<?> statement, @NonNull DefaultSession dseSession, @NonNull InternalDriverContext context, @NonNull String sessionLogPrefix, @NonNull GraphBinaryModule graphBinaryModule, @NonNull GraphSupportChecker graphSupportChecker) {
        this.logPrefix = sessionLogPrefix + "|" + this.hashCode();
        LOG.trace("[{}] Creating new Graph request handler for request {}", (Object)this.logPrefix, statement);
        this.initialStatement = statement;
        this.session = dseSession;
        this.context = context;
        this.graphSupportChecker = graphSupportChecker;
        this.result = new CompletableFuture();
        this.result.exceptionally(t -> {
            try {
                if (t instanceof CancellationException) {
                    this.cancelScheduledTasks();
                }
            }
            catch (Throwable t2) {
                Loggers.warnWithException(LOG, "[{}] Uncaught exception", this.logPrefix, t2);
            }
            return null;
        });
        this.graphBinaryModule = graphBinaryModule;
        this.timer = context.getNettyOptions().getTimer();
        this.activeExecutionsCount = new AtomicInteger(1);
        this.startedSpeculativeExecutionsCount = new AtomicInteger(0);
        this.scheduledExecutions = new CopyOnWriteArrayList<Timeout>();
        this.inFlightCallbacks = new CopyOnWriteArrayList<NodeResponseCallback>();
        this.requestTracker = context.getRequestTracker();
        this.sessionMetricUpdater = this.session.getMetricUpdater();
        Duration timeout = GraphConversions.resolveGraphRequestTimeout(statement, context);
        this.scheduledTimeout = this.scheduleTimeout(timeout);
        this.throttler = context.getRequestThrottler();
        this.throttler.register(this);
    }

    @Override
    public void onThrottleReady(boolean wasDelayed) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(this.initialStatement, this.context);
        if (wasDelayed && this.sessionMetricUpdater.isEnabled(DefaultSessionMetric.THROTTLING_DELAY, executionProfile.getName())) {
            this.sessionMetricUpdater.updateTimer(DefaultSessionMetric.THROTTLING_DELAY, executionProfile.getName(), System.nanoTime() - this.startTimeNanos, TimeUnit.NANOSECONDS);
        }
        Queue<Node> queryPlan = this.initialStatement.getNode() != null ? new SimpleQueryPlan(this.initialStatement.getNode()) : this.context.getLoadBalancingPolicyWrapper().newQueryPlan(this.initialStatement, executionProfile.getName(), this.session);
        this.sendRequest(this.initialStatement, null, queryPlan, 0, 0, true);
    }

    public CompletionStage<AsyncGraphResultSet> handle() {
        return this.result;
    }

    private Timeout scheduleTimeout(Duration timeoutDuration) {
        if (timeoutDuration != null && timeoutDuration.toNanos() > 0L) {
            try {
                return this.timer.newTimeout(timeout1 -> this.setFinalError(this.initialStatement, new DriverTimeoutException("Query timed out after " + timeoutDuration), null, -1), timeoutDuration.toNanos(), TimeUnit.NANOSECONDS);
            }
            catch (IllegalStateException e) {
                this.result.completeExceptionally("cannot be started once stopped".equals(e.getMessage()) ? new IllegalStateException("Session is closed") : e);
            }
        }
        return null;
    }

    private void sendRequest(GraphStatement<?> statement, Node retriedNode, Queue<Node> queryPlan, int currentExecutionIndex, int retryCount, boolean scheduleNextExecution) {
        if (this.result.isDone()) {
            return;
        }
        Node node = retriedNode;
        DriverChannel channel = null;
        if (node == null || (channel = this.session.getChannel(node, this.logPrefix)) == null) {
            while (!this.result.isDone() && (node = queryPlan.poll()) != null && (channel = this.session.getChannel(node, this.logPrefix)) == null) {
            }
        }
        if (channel == null) {
            if (!this.result.isDone() && this.activeExecutionsCount.decrementAndGet() == 0) {
                this.setFinalError(statement, AllNodesFailedException.fromErrors(this.errors), null, -1);
            }
        } else {
            NodeResponseCallback nodeResponseCallback = new NodeResponseCallback(statement, node, queryPlan, channel, currentExecutionIndex, retryCount, scheduleNextExecution, this.logPrefix);
            DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, this.context);
            GraphProtocol graphSubProtocol = GraphConversions.resolveGraphSubProtocol(statement, this.graphSupportChecker, this.context);
            Message message = GraphConversions.createMessageFromGraphStatement(statement, graphSubProtocol, executionProfile, this.context, this.graphBinaryModule);
            Map<String, ByteBuffer> customPayload = GraphConversions.createCustomPayload(statement, graphSubProtocol, executionProfile, this.context, this.graphBinaryModule);
            channel.write(message, statement.isTracing(), customPayload, nodeResponseCallback).addListener(nodeResponseCallback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordError(Node node, Throwable error) {
        List<Map.Entry<Node, Throwable>> errorsSnapshot = this.errors;
        if (errorsSnapshot == null) {
            GraphRequestHandler graphRequestHandler = this;
            synchronized (graphRequestHandler) {
                errorsSnapshot = this.errors;
                if (errorsSnapshot == null) {
                    this.errors = errorsSnapshot = new CopyOnWriteArrayList<Map.Entry<Node, Throwable>>();
                }
            }
        }
        errorsSnapshot.add(new AbstractMap.SimpleEntry<Node, Throwable>(node, error));
    }

    private void cancelScheduledTasks() {
        if (this.scheduledTimeout != null) {
            this.scheduledTimeout.cancel();
        }
        if (this.scheduledExecutions != null) {
            for (Timeout scheduledExecution : this.scheduledExecutions) {
                scheduledExecution.cancel();
            }
        }
        for (NodeResponseCallback callback : this.inFlightCallbacks) {
            callback.cancel();
        }
    }

    private void setFinalResult(Result resultMessage, Frame responseFrame, NodeResponseCallback callback) {
        try {
            ExecutionInfo executionInfo = this.buildExecutionInfo(callback, responseFrame);
            DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(callback.statement, this.context);
            GraphProtocol subProtocol = GraphConversions.resolveGraphSubProtocol(callback.statement, this.graphSupportChecker, this.context);
            ArrayDeque<GraphNode> graphNodes = new ArrayDeque<GraphNode>();
            for (List row : ((Rows)resultMessage).getData()) {
                if (subProtocol.isGraphBinary()) {
                    graphNodes.offer(GraphConversions.createGraphBinaryGraphNode(row, this.graphBinaryModule));
                    continue;
                }
                graphNodes.offer(GraphSONUtils.createGraphNode(row, subProtocol));
            }
            DefaultAsyncGraphResultSet resultSet = new DefaultAsyncGraphResultSet(executionInfo, graphNodes, subProtocol);
            if (this.result.complete(resultSet)) {
                this.cancelScheduledTasks();
                this.throttler.signalSuccess(this);
                long completionTimeNanos = -1L;
                long totalLatencyNanos = -1L;
                if (!(this.requestTracker instanceof NoopRequestTracker)) {
                    completionTimeNanos = System.nanoTime();
                    totalLatencyNanos = completionTimeNanos - this.startTimeNanos;
                    long nodeLatencyNanos = completionTimeNanos - callback.nodeStartTimeNanos;
                    this.requestTracker.onNodeSuccess(callback.statement, nodeLatencyNanos, executionProfile, callback.node, this.logPrefix);
                    this.requestTracker.onSuccess(callback.statement, totalLatencyNanos, executionProfile, callback.node, this.logPrefix);
                }
                if (this.sessionMetricUpdater.isEnabled(DseSessionMetric.GRAPH_REQUESTS, executionProfile.getName())) {
                    if (completionTimeNanos == -1L) {
                        completionTimeNanos = System.nanoTime();
                        totalLatencyNanos = completionTimeNanos - this.startTimeNanos;
                    }
                    this.sessionMetricUpdater.updateTimer(DseSessionMetric.GRAPH_REQUESTS, executionProfile.getName(), totalLatencyNanos, TimeUnit.NANOSECONDS);
                }
            }
            if (!executionInfo.getWarnings().isEmpty() && executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOG_WARNINGS) && LOG.isWarnEnabled()) {
                this.logServerWarnings(callback.statement, executionInfo.getWarnings());
            }
        }
        catch (Throwable error) {
            this.setFinalError(callback.statement, error, callback.node, -1);
        }
    }

    private void logServerWarnings(GraphStatement<?> statement, List<String> warnings) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, this.context);
        StringBuilder statementString = new StringBuilder();
        this.context.getRequestLogFormatter().appendRequest(statement, executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_QUERY_LENGTH, 500), executionProfile.getBoolean(DefaultDriverOption.REQUEST_LOGGER_VALUES, true), executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUES, 50), executionProfile.getInt(DefaultDriverOption.REQUEST_LOGGER_MAX_VALUE_LENGTH, 50), statementString);
        warnings.forEach(warning -> LOG.warn("Query '{}' generated server side warning(s): {}", (Object)statementString, warning));
    }

    private ExecutionInfo buildExecutionInfo(NodeResponseCallback callback, Frame responseFrame) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(callback.statement, this.context);
        return new DefaultExecutionInfo(callback.statement, callback.node, this.startedSpeculativeExecutionsCount.get(), callback.execution, this.errors, null, responseFrame, true, this.session, this.context, executionProfile);
    }

    @Override
    public void onThrottleFailure(@NonNull RequestThrottlingException error) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(this.initialStatement, this.context);
        this.sessionMetricUpdater.incrementCounter(DefaultSessionMetric.THROTTLING_ERRORS, executionProfile.getName());
        this.setFinalError(this.initialStatement, error, null, -1);
    }

    private void setFinalError(GraphStatement<?> statement, Throwable error, Node node, int execution) {
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile(statement, this.context);
        if (error instanceof DriverException) {
            ((DriverException)error).setExecutionInfo(new DefaultExecutionInfo(statement, node, this.startedSpeculativeExecutionsCount.get(), execution, this.errors, null, null, true, this.session, this.context, executionProfile));
        }
        if (this.result.completeExceptionally(error)) {
            this.cancelScheduledTasks();
            if (!(this.requestTracker instanceof NoopRequestTracker)) {
                long latencyNanos = System.nanoTime() - this.startTimeNanos;
                this.requestTracker.onError(statement, error, latencyNanos, executionProfile, node, this.logPrefix);
            }
            if (error instanceof DriverTimeoutException) {
                this.throttler.signalTimeout(this);
                this.sessionMetricUpdater.incrementCounter(DseSessionMetric.GRAPH_CLIENT_TIMEOUTS, executionProfile.getName());
            } else if (!(error instanceof RequestThrottlingException)) {
                this.throttler.signalError(this, error);
            }
        }
    }

    private class NodeResponseCallback
    implements ResponseCallback,
    GenericFutureListener<Future<Void>> {
        private final long nodeStartTimeNanos = System.nanoTime();
        private final GraphStatement<?> statement;
        private final Node node;
        private final Queue<Node> queryPlan;
        private final DriverChannel channel;
        private final int execution;
        private final int retryCount;
        private final boolean scheduleNextExecution;
        private final String logPrefix;
        private final DriverExecutionProfile executionProfile;

        private NodeResponseCallback(GraphStatement<?> statement, Node node, Queue<Node> queryPlan, DriverChannel channel, int execution, int retryCount, boolean scheduleNextExecution, String logPrefix) {
            this.statement = statement;
            this.node = node;
            this.queryPlan = queryPlan;
            this.channel = channel;
            this.execution = execution;
            this.retryCount = retryCount;
            this.scheduleNextExecution = scheduleNextExecution;
            this.logPrefix = logPrefix + "|" + execution;
            this.executionProfile = Conversions.resolveExecutionProfile(statement, GraphRequestHandler.this.context);
        }

        @Override
        public void operationComplete(Future<Void> future) {
            if (!future.isSuccess()) {
                Throwable error = future.cause();
                if (error instanceof EncoderException && error.getCause() instanceof FrameTooLongException) {
                    this.trackNodeError(this.node, error.getCause(), -1L);
                    GraphRequestHandler.this.setFinalError(this.statement, error.getCause(), this.node, this.execution);
                } else {
                    LOG.trace("[{}] Failed to send request on {}, trying next node (cause: {})", new Object[]{this.logPrefix, this.channel, error});
                    GraphRequestHandler.this.recordError(this.node, error);
                    this.trackNodeError(this.node, error, -1L);
                    ((DefaultNode)this.node).getMetricUpdater().incrementCounter(DefaultNodeMetric.UNSENT_REQUESTS, this.executionProfile.getName());
                    GraphRequestHandler.this.sendRequest(this.statement, null, this.queryPlan, this.execution, this.retryCount, this.scheduleNextExecution);
                }
            } else {
                LOG.trace("[{}] Request sent on {}", (Object)this.logPrefix, (Object)this.channel);
                if (GraphRequestHandler.this.result.isDone()) {
                    this.cancel();
                } else {
                    GraphRequestHandler.this.inFlightCallbacks.add(this);
                    if (this.scheduleNextExecution && Conversions.resolveIdempotence(this.statement, GraphRequestHandler.this.context)) {
                        long nextDelay;
                        int nextExecution = this.execution + 1;
                        try {
                            nextDelay = Conversions.resolveSpeculativeExecutionPolicy(this.statement, GraphRequestHandler.this.context).nextExecution(this.node, null, this.statement, nextExecution);
                        }
                        catch (Throwable cause) {
                            LOG.error("[{}] Unexpected error while invoking the speculative execution policy", (Object)this.logPrefix, (Object)cause);
                            return;
                        }
                        if (nextDelay >= 0L) {
                            this.scheduleSpeculativeExecution(nextExecution, nextDelay);
                        } else {
                            LOG.trace("[{}] Speculative execution policy returned {}, no next execution", (Object)this.logPrefix, (Object)nextDelay);
                        }
                    }
                }
            }
        }

        private void scheduleSpeculativeExecution(int index, long delay) {
            block2: {
                LOG.trace("[{}] Scheduling speculative execution {} in {} ms", new Object[]{this.logPrefix, index, delay});
                try {
                    GraphRequestHandler.this.scheduledExecutions.add(GraphRequestHandler.this.timer.newTimeout(timeout1 -> {
                        if (!GraphRequestHandler.this.result.isDone()) {
                            LOG.trace("[{}] Starting speculative execution {}", (Object)GraphRequestHandler.this.logPrefix, (Object)index);
                            GraphRequestHandler.this.activeExecutionsCount.incrementAndGet();
                            GraphRequestHandler.this.startedSpeculativeExecutionsCount.incrementAndGet();
                            ((DefaultNode)this.node).getMetricUpdater().incrementCounter(DefaultNodeMetric.SPECULATIVE_EXECUTIONS, this.executionProfile.getName());
                            GraphRequestHandler.this.sendRequest(this.statement, null, this.queryPlan, index, 0, true);
                        }
                    }, delay, TimeUnit.MILLISECONDS));
                }
                catch (IllegalStateException e) {
                    if ("cannot be started once stopped".equals(e.getMessage())) break block2;
                    Loggers.warnWithException(LOG, "[{}] Error while scheduling speculative execution", this.logPrefix, e);
                }
            }
        }

        @Override
        public void onResponse(Frame responseFrame) {
            long nodeResponseTimeNanos = -1L;
            NodeMetricUpdater nodeMetricUpdater = ((DefaultNode)this.node).getMetricUpdater();
            if (nodeMetricUpdater.isEnabled(DseNodeMetric.GRAPH_MESSAGES, this.executionProfile.getName())) {
                nodeResponseTimeNanos = System.nanoTime();
                long nodeLatency = System.nanoTime() - this.nodeStartTimeNanos;
                nodeMetricUpdater.updateTimer(DseNodeMetric.GRAPH_MESSAGES, this.executionProfile.getName(), nodeLatency, TimeUnit.NANOSECONDS);
            }
            GraphRequestHandler.this.inFlightCallbacks.remove(this);
            if (GraphRequestHandler.this.result.isDone()) {
                return;
            }
            try {
                Message responseMessage = responseFrame.message;
                if (responseMessage instanceof Result) {
                    LOG.trace("[{}] Got result, completing", (Object)this.logPrefix);
                    GraphRequestHandler.this.setFinalResult((Result)responseMessage, responseFrame, this);
                } else if (responseMessage instanceof Error) {
                    LOG.trace("[{}] Got error response, processing", (Object)this.logPrefix);
                    this.processErrorResponse((Error)responseMessage);
                } else {
                    this.trackNodeError(this.node, new IllegalStateException("Unexpected response " + responseMessage), nodeResponseTimeNanos);
                    GraphRequestHandler.this.setFinalError(this.statement, new IllegalStateException("Unexpected response " + responseMessage), this.node, this.execution);
                }
            }
            catch (Throwable t) {
                this.trackNodeError(this.node, t, nodeResponseTimeNanos);
                GraphRequestHandler.this.setFinalError(this.statement, t, this.node, this.execution);
            }
        }

        private void processErrorResponse(Error errorMessage) {
            CoordinatorException error = Conversions.toThrowable(this.node, errorMessage, GraphRequestHandler.this.context);
            NodeMetricUpdater metricUpdater = ((DefaultNode)this.node).getMetricUpdater();
            if (error instanceof BootstrappingException) {
                LOG.trace("[{}] {} is bootstrapping, trying next node", (Object)this.logPrefix, (Object)this.node);
                GraphRequestHandler.this.recordError(this.node, error);
                this.trackNodeError(this.node, error, -1L);
                GraphRequestHandler.this.sendRequest(this.statement, null, this.queryPlan, this.execution, this.retryCount, false);
            } else if (error instanceof QueryValidationException || error instanceof FunctionFailureException || error instanceof ProtocolError) {
                LOG.trace("[{}] Unrecoverable error, rethrowing", (Object)this.logPrefix);
                metricUpdater.incrementCounter(DefaultNodeMetric.OTHER_ERRORS, this.executionProfile.getName());
                this.trackNodeError(this.node, error, -1L);
                GraphRequestHandler.this.setFinalError(this.statement, error, this.node, this.execution);
            } else {
                RetryVerdict verdict;
                RetryPolicy retryPolicy = Conversions.resolveRetryPolicy(this.statement, GraphRequestHandler.this.context);
                if (error instanceof ReadTimeoutException) {
                    ReadTimeoutException readTimeout = (ReadTimeoutException)error;
                    verdict = retryPolicy.onReadTimeoutVerdict(this.statement, readTimeout.getConsistencyLevel(), readTimeout.getBlockFor(), readTimeout.getReceived(), readTimeout.wasDataPresent(), this.retryCount);
                    this.updateErrorMetrics(metricUpdater, verdict, DefaultNodeMetric.READ_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_READ_TIMEOUT, DefaultNodeMetric.IGNORES_ON_READ_TIMEOUT);
                } else if (error instanceof WriteTimeoutException) {
                    WriteTimeoutException writeTimeout = (WriteTimeoutException)error;
                    verdict = Conversions.resolveIdempotence(this.statement, GraphRequestHandler.this.context) ? retryPolicy.onWriteTimeoutVerdict(this.statement, writeTimeout.getConsistencyLevel(), writeTimeout.getWriteType(), writeTimeout.getBlockFor(), writeTimeout.getReceived(), this.retryCount) : RetryVerdict.RETHROW;
                    this.updateErrorMetrics(metricUpdater, verdict, DefaultNodeMetric.WRITE_TIMEOUTS, DefaultNodeMetric.RETRIES_ON_WRITE_TIMEOUT, DefaultNodeMetric.IGNORES_ON_WRITE_TIMEOUT);
                } else if (error instanceof UnavailableException) {
                    UnavailableException unavailable = (UnavailableException)error;
                    verdict = retryPolicy.onUnavailableVerdict(this.statement, unavailable.getConsistencyLevel(), unavailable.getRequired(), unavailable.getAlive(), this.retryCount);
                    this.updateErrorMetrics(metricUpdater, verdict, DefaultNodeMetric.UNAVAILABLES, DefaultNodeMetric.RETRIES_ON_UNAVAILABLE, DefaultNodeMetric.IGNORES_ON_UNAVAILABLE);
                } else {
                    verdict = Conversions.resolveIdempotence(this.statement, GraphRequestHandler.this.context) ? retryPolicy.onErrorResponseVerdict(this.statement, error, this.retryCount) : RetryVerdict.RETHROW;
                    this.updateErrorMetrics(metricUpdater, verdict, DefaultNodeMetric.OTHER_ERRORS, DefaultNodeMetric.RETRIES_ON_OTHER_ERROR, DefaultNodeMetric.IGNORES_ON_OTHER_ERROR);
                }
                this.processRetryVerdict(verdict, error);
            }
        }

        private void processRetryVerdict(RetryVerdict verdict, Throwable error) {
            LOG.trace("[{}] Processing retry decision {}", (Object)this.logPrefix, (Object)verdict);
            switch (verdict.getRetryDecision()) {
                case RETRY_SAME: {
                    GraphRequestHandler.this.recordError(this.node, error);
                    this.trackNodeError(this.node, error, -1L);
                    GraphRequestHandler.this.sendRequest(verdict.getRetryRequest(this.statement), this.node, this.queryPlan, this.execution, this.retryCount + 1, false);
                    break;
                }
                case RETRY_NEXT: {
                    GraphRequestHandler.this.recordError(this.node, error);
                    this.trackNodeError(this.node, error, -1L);
                    GraphRequestHandler.this.sendRequest(verdict.getRetryRequest(this.statement), null, this.queryPlan, this.execution, this.retryCount + 1, false);
                    break;
                }
                case RETHROW: {
                    this.trackNodeError(this.node, error, -1L);
                    GraphRequestHandler.this.setFinalError(this.statement, error, this.node, this.execution);
                    break;
                }
                case IGNORE: {
                    GraphRequestHandler.this.setFinalResult((Result)com.datastax.oss.protocol.internal.response.result.Void.INSTANCE, null, this);
                }
            }
        }

        private void updateErrorMetrics(NodeMetricUpdater metricUpdater, RetryVerdict verdict, DefaultNodeMetric error, DefaultNodeMetric retriesOnError, DefaultNodeMetric ignoresOnError) {
            metricUpdater.incrementCounter(error, this.executionProfile.getName());
            switch (verdict.getRetryDecision()) {
                case RETRY_SAME: 
                case RETRY_NEXT: {
                    metricUpdater.incrementCounter(DefaultNodeMetric.RETRIES, this.executionProfile.getName());
                    metricUpdater.incrementCounter(retriesOnError, this.executionProfile.getName());
                    break;
                }
                case IGNORE: {
                    metricUpdater.incrementCounter(DefaultNodeMetric.IGNORES, this.executionProfile.getName());
                    metricUpdater.incrementCounter(ignoresOnError, this.executionProfile.getName());
                    break;
                }
            }
        }

        @Override
        public void onFailure(Throwable error) {
            RetryVerdict verdict;
            GraphRequestHandler.this.inFlightCallbacks.remove(this);
            if (GraphRequestHandler.this.result.isDone()) {
                return;
            }
            LOG.trace("[{}] Request failure, processing: {}", (Object)this.logPrefix, (Object)error);
            if (!Conversions.resolveIdempotence(this.statement, GraphRequestHandler.this.context) || error instanceof FrameTooLongException) {
                verdict = RetryVerdict.RETHROW;
            } else {
                try {
                    RetryPolicy retryPolicy = Conversions.resolveRetryPolicy(this.statement, GraphRequestHandler.this.context);
                    verdict = retryPolicy.onRequestAbortedVerdict(this.statement, error, this.retryCount);
                }
                catch (Throwable cause) {
                    GraphRequestHandler.this.setFinalError(this.statement, new IllegalStateException("Unexpected error while invoking the retry policy", cause), this.node, -1);
                    return;
                }
            }
            this.processRetryVerdict(verdict, error);
            this.updateErrorMetrics(((DefaultNode)this.node).getMetricUpdater(), verdict, DefaultNodeMetric.ABORTED_REQUESTS, DefaultNodeMetric.RETRIES_ON_ABORTED, DefaultNodeMetric.IGNORES_ON_ABORTED);
        }

        void cancel() {
            try {
                if (!this.channel.closeFuture().isDone()) {
                    this.channel.cancel(this);
                }
            }
            catch (Throwable t) {
                Loggers.warnWithException(LOG, "[{}] Error cancelling", this.logPrefix, t);
            }
        }

        private void trackNodeError(Node node, Throwable error, long nodeResponseTimeNanos) {
            if (GraphRequestHandler.this.requestTracker instanceof NoopRequestTracker) {
                return;
            }
            if (nodeResponseTimeNanos == -1L) {
                nodeResponseTimeNanos = System.nanoTime();
            }
            long latencyNanos = nodeResponseTimeNanos - this.nodeStartTimeNanos;
            GraphRequestHandler.this.requestTracker.onNodeError(this.statement, error, latencyNanos, this.executionProfile, node, this.logPrefix);
        }

        public String toString() {
            return this.logPrefix;
        }
    }
}

