/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.exceptions.DriverInternalError;
import java.util.concurrent.ExecutionException;

/**
 * Copied here from com.datastax.driver.core.DriverThrowables because we don't want this class to be
 * public.
 */
class DriverThrowables {

  static RuntimeException propagateCause(ExecutionException e) {
    Throwable cause = e.getCause();

    if (cause instanceof Error) throw ((Error) cause);

    // We could just rethrow e.getCause(). However, the cause of the ExecutionException has likely
    // been
    // created on the I/O thread receiving the response. Which means that the stacktrace associated
    // with said cause will make no mention of the current thread. This is painful for say, finding
    // out which execute() statement actually raised the exception. So instead, we re-create the
    // exception.
    if (cause instanceof DriverException) throw ((DriverException) cause).copy();
    else throw new DriverInternalError("Unexpected exception thrown", cause);
  }
}
