/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri.ogc;

import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryEngine;
import com.datastax.shaded.esri.Operator;
import com.datastax.shaded.esri.OperatorBoundary;
import com.datastax.shaded.esri.OperatorExportToGeoJson;
import com.datastax.shaded.esri.OperatorExportToWkb;
import com.datastax.shaded.esri.OperatorFactoryLocal;
import com.datastax.shaded.esri.Polyline;
import com.datastax.shaded.esri.SpatialReference;
import com.datastax.shaded.esri.ogc.OGCGeometry;
import com.datastax.shaded.esri.ogc.OGCLineString;
import com.datastax.shaded.esri.ogc.OGCMultiCurve;
import java.nio.ByteBuffer;

public class OGCMultiLineString
extends OGCMultiCurve {
    Polyline polyline;

    public OGCMultiLineString(Polyline poly, SpatialReference sr) {
        this.polyline = poly;
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 8);
    }

    @Override
    public String asGeoJson() {
        OperatorExportToGeoJson op = (OperatorExportToGeoJson)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToGeoJson);
        return op.execute(1, null, this.getEsriGeometry());
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(8, this.getEsriGeometry(), null);
    }

    @Override
    public OGCGeometry geometryN(int n) {
        OGCLineString ls = new OGCLineString(this.polyline, n, this.esriSR);
        return ls;
    }

    @Override
    public String geometryType() {
        return "MultiLineString";
    }

    @Override
    public OGCGeometry boundary() {
        OperatorBoundary op = (OperatorBoundary)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.Boundary);
        Geometry g = op.execute(this.polyline, null);
        return OGCGeometry.createFromEsriGeometry(g, this.esriSR, true);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polyline;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }
}

