/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.dse.graph.DefaultGraphNode;
import com.datastax.driver.dse.graph.Element;
import com.datastax.driver.dse.graph.PropertyGraphNodeParser;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.databind.JavaType;
import com.datastax.shaded.jackson.databind.JsonNode;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.google.common.reflect.TypeToken;

class PropertyGraphNode
extends DefaultGraphNode {
    private final String propertyName;
    private final Element parent;

    PropertyGraphNode(JsonNode delegate, ObjectMapper objectMapper, String propertyName, Element parent) {
        super(delegate, objectMapper);
        this.propertyName = propertyName;
        this.parent = parent;
    }

    @Override
    public <T> T as(Class<T> clazz) {
        return this.as(TypeToken.of(clazz));
    }

    @Override
    public <T> T as(TypeToken<T> type) {
        try {
            PropertyGraphNodeParser parser = new PropertyGraphNodeParser(this.delegate, this.objectMapper, this.propertyName, this.parent);
            JavaType javaType = this.objectMapper.constructType(type.getType());
            return this.objectMapper.readValue((JsonParser)parser, javaType);
        }
        catch (Exception e) {
            throw new DriverException("Cannot deserialize result as " + type, e);
        }
    }
}

