/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.geometry.Distance;
import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.driver.dse.graph.GraphSON2JacksonModule;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import com.datastax.shaded.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class GraphSON2DseGraphDriverModule
extends GraphSON2JacksonModule {
    GraphSON2DseGraphDriverModule() {
        super("graph-graphson2dsegraph");
        this.addSerializer(LineString.class, new LineStringGeometrySerializer());
        this.addSerializer(Distance.class, new DistanceGeometrySerializer());
        this.addSerializer(Point.class, new PointGeometrySerializer());
        this.addSerializer(Polygon.class, new PolygonGeometrySerializer());
        this.addDeserializer(LineString.class, new LineStringGeometryDeserializer());
        this.addDeserializer(Point.class, new PointGeometryDeserializer());
        this.addDeserializer(Polygon.class, new PolygonGeometryDeserializer());
        this.addDeserializer(Distance.class, new DistanceGeometryDeserializer());
    }

    @Override
    public Map<Class<?>, String> getTypeDefinitions() {
        HashMap definitions = new HashMap();
        definitions.put(LineString.class, "LineString");
        definitions.put(Point.class, "Point");
        definitions.put(Polygon.class, "Polygon");
        definitions.put(Distance.class, "Distance");
        definitions.put(byte[].class, "Blob");
        return definitions;
    }

    @Override
    public String getTypeNamespace() {
        return "dse";
    }

    static final class DistanceGeometryDeserializer
    extends AbstractGeometryJacksonDeserializer<Distance> {
        DistanceGeometryDeserializer() {
            super(Distance.class);
        }

        @Override
        public Distance parse(String val) {
            return Distance.fromWellKnownText(val);
        }
    }

    static final class DistanceGeometrySerializer
    extends AbstractGeometryJacksonSerializer<Distance> {
        DistanceGeometrySerializer() {
            super(Distance.class);
        }
    }

    static final class PointGeometryDeserializer
    extends AbstractGeometryJacksonDeserializer<Point> {
        PointGeometryDeserializer() {
            super(Point.class);
        }

        @Override
        public Point parse(String val) {
            return Point.fromWellKnownText(val);
        }
    }

    static final class PointGeometrySerializer
    extends AbstractGeometryJacksonSerializer<Point> {
        PointGeometrySerializer() {
            super(Point.class);
        }
    }

    static final class PolygonGeometryDeserializer
    extends AbstractGeometryJacksonDeserializer<Polygon> {
        PolygonGeometryDeserializer() {
            super(Polygon.class);
        }

        @Override
        public Polygon parse(String val) {
            return Polygon.fromWellKnownText(val);
        }
    }

    static final class PolygonGeometrySerializer
    extends AbstractGeometryJacksonSerializer<Polygon> {
        PolygonGeometrySerializer() {
            super(Polygon.class);
        }
    }

    static final class LineStringGeometryDeserializer
    extends AbstractGeometryJacksonDeserializer<LineString> {
        LineStringGeometryDeserializer() {
            super(LineString.class);
        }

        @Override
        public LineString parse(String val) {
            return LineString.fromWellKnownText(val);
        }
    }

    static final class LineStringGeometrySerializer
    extends AbstractGeometryJacksonSerializer<LineString> {
        LineStringGeometrySerializer() {
            super(LineString.class);
        }
    }

    static abstract class AbstractGeometryJacksonSerializer<T extends Geometry>
    extends StdScalarSerializer<T> {
        protected AbstractGeometryJacksonSerializer(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public void serialize(T value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            gen.writeString(((Geometry)value).asWellKnownText());
        }
    }

    static abstract class AbstractGeometryJacksonDeserializer<T extends Geometry>
    extends StdDeserializer<T> {
        protected AbstractGeometryJacksonDeserializer(Class<T> clazz) {
            super(clazz);
        }

        protected abstract T parse(String var1);

        @Override
        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this.parse(jsonParser.getText());
        }
    }
}

