/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.IgnoreJDK6Requirement;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.core.Version;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.JsonDeserializer;
import com.datastax.shaded.jackson.databind.JsonSerializer;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import com.datastax.shaded.jackson.databind.module.SimpleModule;
import com.datastax.shaded.jackson.databind.ser.std.StdSerializer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;

@IgnoreJDK6Requirement
class GraphSON1JavaTimeModule
extends SimpleModule {
    GraphSON1JavaTimeModule(String name, Version version) {
        super(name, version, GraphSON1JavaTimeModule.createDeserializers(), GraphSON1JavaTimeModule.createSerializers());
    }

    private static Map<Class<?>, JsonDeserializer<?>> createDeserializers() {
        return ImmutableMap.builder().put(Duration.class, (Object)new DurationJacksonDeserializer()).put(Instant.class, (Object)new InstantJacksonDeserializer()).put(LocalDate.class, (Object)new LocalDateJacksonDeserializer()).put(LocalTime.class, (Object)new LocalTimeJacksonDeserializer()).build();
    }

    private static List<JsonSerializer<?>> createSerializers() {
        return ImmutableList.builder().add((Object)new DurationJacksonSerializer()).add((Object)new InstantJacksonSerializer()).add((Object)new LocalDateJacksonSerializer()).add((Object)new LocalTimeJacksonSerializer()).build();
    }

    @IgnoreJDK6Requirement
    static final class LocalTimeJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<LocalTime> {
        LocalTimeJacksonDeserializer() {
            super(LocalTime.class);
        }

        @Override
        public LocalTime parse(String val) {
            return LocalTime.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class LocalTimeJacksonSerializer
    extends AbstractJavaTimeSerializer<LocalTime> {
        LocalTimeJacksonSerializer() {
            super(LocalTime.class);
        }
    }

    @IgnoreJDK6Requirement
    static final class LocalDateJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<LocalDate> {
        LocalDateJacksonDeserializer() {
            super(LocalDate.class);
        }

        @Override
        public LocalDate parse(String val) {
            return LocalDate.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class LocalDateJacksonSerializer
    extends AbstractJavaTimeSerializer<LocalDate> {
        LocalDateJacksonSerializer() {
            super(LocalDate.class);
        }
    }

    @IgnoreJDK6Requirement
    static final class InstantJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Instant> {
        InstantJacksonDeserializer() {
            super(Instant.class);
        }

        @Override
        public Instant parse(String val) {
            return Instant.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class InstantJacksonSerializer
    extends AbstractJavaTimeSerializer<Instant> {
        InstantJacksonSerializer() {
            super(Instant.class);
        }
    }

    @IgnoreJDK6Requirement
    static final class DurationJacksonDeserializer
    extends AbstractJavaTimeJacksonDeserializer<Duration> {
        DurationJacksonDeserializer() {
            super(Duration.class);
        }

        @Override
        public Duration parse(String val) {
            return Duration.parse(val);
        }
    }

    @IgnoreJDK6Requirement
    static final class DurationJacksonSerializer
    extends AbstractJavaTimeSerializer<Duration> {
        DurationJacksonSerializer() {
            super(Duration.class);
        }
    }

    @IgnoreJDK6Requirement
    static abstract class AbstractJavaTimeJacksonDeserializer<T>
    extends StdDeserializer<T> {
        AbstractJavaTimeJacksonDeserializer(Class<T> clazz) {
            super(clazz);
        }

        abstract T parse(String var1);

        @Override
        public T deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            return this.parse(jsonParser.getText());
        }
    }

    @IgnoreJDK6Requirement
    static abstract class AbstractJavaTimeSerializer<T>
    extends StdSerializer<T> {
        AbstractJavaTimeSerializer(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public void serialize(T value, JsonGenerator gen, SerializerProvider serializerProvider) throws IOException {
            gen.writeString(value.toString());
        }
    }
}

