/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ClasspathUtil;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.graph.DefaultGraphNode;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphSON1DefaultModule;
import com.datastax.driver.dse.graph.GraphSON1DriverTimeModule;
import com.datastax.driver.dse.graph.GraphSON1JavaTimeModule;
import com.datastax.driver.dse.graph.GraphSON2DriverObjectsModule;
import com.datastax.driver.dse.graph.GraphSON2DriverTimeModule;
import com.datastax.driver.dse.graph.GraphSON2DseGraphDriverModule;
import com.datastax.driver.dse.graph.GraphSON2GremlinDriverModule;
import com.datastax.driver.dse.graph.GraphSON2GremlinGraphDriverModule;
import com.datastax.driver.dse.graph.GraphSON2GremlinXDriverModule;
import com.datastax.driver.dse.graph.GraphSON2JavaTimeModule;
import com.datastax.driver.dse.graph.GraphSON2Mapper;
import com.datastax.driver.dse.graph.GraphSON2TinkerDriverModule;
import com.datastax.driver.dse.graph.ObjectGraphNode;
import com.datastax.shaded.jackson.core.Version;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphJsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphJsonUtils.class);
    private static final ObjectMapper GRAPHSON1_OBJECT_MAPPER;
    private static final ObjectMapper GRAPHSON2_OBJECT_MAPPER;
    public static final Function<Row, GraphNode> ROW_TO_GRAPHSON2_OBJECTGRAPHNODE;

    private static Version dseDriverVersion() {
        String versionStr = DseCluster.getDseDriverVersion();
        VersionNumber version = VersionNumber.parse(versionStr);
        return new Version(version.getMajor(), version.getMinor(), version.getPatch(), versionStr.contains("-SNAPSHOT") ? "SNAPSHOT" : null, "com.datastax.cassandra", "dse-driver");
    }

    static GraphNode readStringAsTree(String content) {
        try {
            return new DefaultGraphNode(GRAPHSON1_OBJECT_MAPPER.readTree(content), GRAPHSON1_OBJECT_MAPPER);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static String writeValueAsString(Object value) {
        try {
            return GRAPHSON1_OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static GraphNode readStringAsTreeGraphson20(String content) {
        try {
            return new ObjectGraphNode(GRAPHSON2_OBJECT_MAPPER.readValue(content, Object.class));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static String writeValueAsStringGraphson20(Object value) {
        try {
            return GRAPHSON2_OBJECT_MAPPER.writeValueAsString(value);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    static {
        ROW_TO_GRAPHSON2_OBJECTGRAPHNODE = new Function<Row, GraphNode>(){

            public GraphNode apply(Row input) {
                try {
                    if (input == null) {
                        return null;
                    }
                    if (input.getColumnDefinitions().contains("gremlin")) {
                        return GraphJsonUtils.readStringAsTreeGraphson20(input.getString("gremlin"));
                    }
                    return null;
                }
                catch (Exception e) {
                    throw new DriverException("Could not deserialize the response of this Graph query.", e);
                }
            }
        };
        GRAPHSON1_OBJECT_MAPPER = new ObjectMapper();
        Version dseDriverVersion = GraphJsonUtils.dseDriverVersion();
        GRAPHSON1_OBJECT_MAPPER.registerModule(new GraphSON1DefaultModule("graph-graphson1default", dseDriverVersion));
        GraphSON2Mapper.Builder graphSON2MapperBuilder = GraphSON2Mapper.build().addCustomModule(new GraphSON2GremlinDriverModule()).addCustomModule(new GraphSON2GremlinXDriverModule()).addCustomModule(new GraphSON2GremlinGraphDriverModule()).addCustomModule(new GraphSON2DseGraphDriverModule()).addCustomModule(new GraphSON2TinkerDriverModule()).addCustomModule(new GraphSON2DriverObjectsModule());
        if (ClasspathUtil.isJavaTimeAvailable()) {
            LOGGER.debug("JSR 310 found on the classpath, registering serializers for java.time temporal types");
            GRAPHSON1_OBJECT_MAPPER.registerModule(new GraphSON1JavaTimeModule("graph-graphson1javatime", dseDriverVersion));
            GRAPHSON1_OBJECT_MAPPER.registerModule(new GraphSON1DriverTimeModule("graph-graphson1drivertime", dseDriverVersion));
            graphSON2MapperBuilder.addCustomModule(new GraphSON2JavaTimeModule());
        } else {
            LOGGER.debug("JSR 310 not found on the classpath, not registering serializers for java.time temporal types");
            GRAPHSON1_OBJECT_MAPPER.registerModule(new GraphSON1DriverTimeModule("graph-graphson1drivertime", dseDriverVersion));
            graphSON2MapperBuilder.addCustomModule(new GraphSON2DriverTimeModule());
        }
        GRAPHSON2_OBJECT_MAPPER = graphSON2MapperBuilder.create().createMapper();
    }
}

