/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.DefaultGraphNode;
import com.datastax.driver.dse.graph.DefaultPath;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.core.JsonToken;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.JsonNode;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;

class DefaultPathDeserializer
extends StdDeserializer<DefaultPath> {
    DefaultPathDeserializer() {
        super(DefaultPath.class);
    }

    @Override
    public DefaultPath deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
        DefaultPath path = new DefaultPath();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            assert (parser.getCurrentToken() == JsonToken.FIELD_NAME);
            String name = parser.getCurrentName();
            parser.nextToken();
            if ("labels".equals(name)) {
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    assert (parser.getCurrentToken() == JsonToken.START_ARRAY);
                    LinkedHashSet<String> group = new LinkedHashSet<String>();
                    while (parser.nextToken() != JsonToken.END_ARRAY) {
                        assert (parser.getCurrentToken() == JsonToken.VALUE_STRING);
                        String label = parser.readValueAs(String.class);
                        group.add(label);
                    }
                    if (path.labels == null) {
                        path.labels = new ArrayList<Set<String>>();
                    }
                    path.labels.add(group);
                }
                continue;
            }
            if ("objects".equals(name)) {
                assert (parser.getCurrentToken() == JsonToken.START_ARRAY);
                while (parser.nextToken() != JsonToken.END_ARRAY) {
                    assert (parser.getCurrentToken() == JsonToken.START_OBJECT);
                    JsonNode jacksonNode = (JsonNode)parser.readValueAsTree();
                    if (path.objects == null) {
                        path.objects = new ArrayList<GraphNode>();
                    }
                    path.objects.add(new DefaultGraphNode(jacksonNode, (ObjectMapper)parser.getCodec()));
                }
                continue;
            }
            parser.skipChildren();
        }
        return path;
    }
}

