/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.InsightsSchema;
import com.datastax.driver.core.PackageUtil;
import com.datastax.driver.core.policies.ConstantSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.PercentileSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import java.util.HashMap;

class SpeculativeExecutionInfoFinder {
    SpeculativeExecutionInfoFinder() {
    }

    InsightsSchema.SpeculativeExecutionInfo getSpeculativeExecutionInfo(SpeculativeExecutionPolicy speculativeExecutionPolicy) {
        String type = speculativeExecutionPolicy.getClass().getSimpleName();
        String namespace = PackageUtil.getNamespace(speculativeExecutionPolicy.getClass());
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (speculativeExecutionPolicy instanceof ConstantSpeculativeExecutionPolicy) {
            ConstantSpeculativeExecutionPolicy constantSpeculativeExecutionPolicy = (ConstantSpeculativeExecutionPolicy)speculativeExecutionPolicy;
            options.put("constantDelayMillis", constantSpeculativeExecutionPolicy.getConstantDelayMillis());
            options.put("maxSpeculativeExecutions", constantSpeculativeExecutionPolicy.getMaxSpeculativeExecutions());
        } else if (speculativeExecutionPolicy instanceof PercentileSpeculativeExecutionPolicy) {
            PercentileSpeculativeExecutionPolicy percentileSpeculativeExecutionPolicy = (PercentileSpeculativeExecutionPolicy)speculativeExecutionPolicy;
            options.put("maxSpeculativeExecutions", percentileSpeculativeExecutionPolicy.getMaxSpeculativeExecutions());
            options.put("percentile", percentileSpeculativeExecutionPolicy.getPercentile());
        }
        return new InsightsSchema.SpeculativeExecutionInfo(type, namespace, options);
    }
}

