/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.InsightsSchema;
import com.datastax.driver.core.PackageUtil;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import java.util.HashMap;

class ReconnectionPolicyInfoFinder {
    ReconnectionPolicyInfoFinder() {
    }

    InsightsSchema.ReconnectionPolicyInfo getReconnectionPolicyInfo(ReconnectionPolicy reconnectionPolicy) {
        String type = reconnectionPolicy.getClass().getSimpleName();
        String namespace = PackageUtil.getNamespace(reconnectionPolicy.getClass());
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (reconnectionPolicy instanceof ConstantReconnectionPolicy) {
            ConstantReconnectionPolicy constantReconnectionPolicy = (ConstantReconnectionPolicy)reconnectionPolicy;
            options.put("delayMs", constantReconnectionPolicy.getConstantDelayMs());
        } else if (reconnectionPolicy instanceof ExponentialReconnectionPolicy) {
            ExponentialReconnectionPolicy exponentialReconnectionPolicy = (ExponentialReconnectionPolicy)reconnectionPolicy;
            options.put("maxDelayMs", exponentialReconnectionPolicy.getMaxDelayMs());
            options.put("baseDelayMs", exponentialReconnectionPolicy.getBaseDelayMs());
            options.put("maxAttempts", exponentialReconnectionPolicy.getMaxAttempts());
        }
        return new InsightsSchema.ReconnectionPolicyInfo(type, namespace, options);
    }
}

