/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.InsightsSchema;
import com.datastax.driver.core.Native;
import com.datastax.driver.core.utils.MoreObjects;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;

class PlatformInfoFinder {
    static final String UNVERIFIED_RUNTIME_VERSION = "UNVERIFIED";
    private static final String MAVEN_IGNORE_LINE = "The following files have been resolved:";
    private static final Pattern DEPENDENCY_SPLIT_REGEX = Pattern.compile(":");
    private static final String UNKNOWN = "UNKNOWN";
    private final Function<DependencyInfo, URL> propertiesUrlProvider;
    private static final Function<DependencyInfo, URL> M2_PROPERTIES_PROVIDER = new Function<DependencyInfo, URL>(){

        public URL apply(DependencyInfo d) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader == null) {
                contextClassLoader = PlatformInfoFinder.class.getClassLoader();
            }
            return contextClassLoader.getResource("META-INF/maven/" + d.groupId + "/" + d.artifactId + "/pom.properties");
        }
    };

    PlatformInfoFinder() {
        this(M2_PROPERTIES_PROVIDER);
    }

    @VisibleForTesting
    PlatformInfoFinder(Function<DependencyInfo, URL> pomPropertiesUrlProvider) {
        this.propertiesUrlProvider = pomPropertiesUrlProvider;
    }

    InsightsSchema.InsightsPlatformInfo getInsightsPlatformInfo() {
        InsightsSchema.InsightsPlatformInfo.OS os = this.getOsInfo();
        InsightsSchema.InsightsPlatformInfo.CPUS cpus = this.getCpuInfo();
        Map<String, Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> runtimeInfo = this.getRuntimeInfo();
        return new InsightsSchema.InsightsPlatformInfo(os, cpus, runtimeInfo);
    }

    private Map<String, Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> getRuntimeInfo() {
        Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> coreDeps = this.fetchDependenciesFromFile(this.getClass().getResourceAsStream("/com/datastax/driver/core/deps.txt"));
        Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> graphDeps = this.fetchDependenciesFromFile(this.getClass().getResourceAsStream("/com/datastax/dse/graph/api/deps.txt"));
        Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> mappingDeps = this.fetchDependenciesFromFile(this.getClass().getResourceAsStream("/com/datastax/driver/mapping/deps.txt"));
        Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> extrasDeps = this.fetchDependenciesFromFile(this.getClass().getResourceAsStream("/com/datastax/driver/extras/codecs/deps.txt"));
        LinkedHashMap<String, Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> runtimeDependencies = new LinkedHashMap<String, Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>>();
        this.putIfNonEmpty(coreDeps, runtimeDependencies, "core");
        this.putIfNonEmpty(graphDeps, runtimeDependencies, "graph");
        this.putIfNonEmpty(mappingDeps, runtimeDependencies, "mapping");
        this.putIfNonEmpty(extrasDeps, runtimeDependencies, "extras");
        this.addJavaVersion(runtimeDependencies);
        return runtimeDependencies;
    }

    private void putIfNonEmpty(Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> moduleDependencies, Map<String, Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> runtimeDependencies, String moduleName) {
        if (!moduleDependencies.isEmpty()) {
            runtimeDependencies.put(moduleName, moduleDependencies);
        }
    }

    @VisibleForTesting
    void addJavaVersion(Map<String, Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>> runtimeDependencies) {
        Package javaPackage = Runtime.class.getPackage();
        LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> javaDependencies = new LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        javaDependencies.put("version", this.toSameRuntimeAndCompileVersion(javaPackage.getImplementationVersion()));
        javaDependencies.put("vendor", this.toSameRuntimeAndCompileVersion(javaPackage.getImplementationVendor()));
        javaDependencies.put("title", this.toSameRuntimeAndCompileVersion(javaPackage.getImplementationTitle()));
        this.putIfNonEmpty(javaDependencies, runtimeDependencies, "java");
    }

    private InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions toSameRuntimeAndCompileVersion(String version) {
        return new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions(version, version, false);
    }

    Map<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> fetchDependenciesFromFile(InputStream inputStream) {
        LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> dependencies = new LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        if (inputStream == null) {
            return dependencies;
        }
        try {
            List<DependencyInfo> dependenciesFromFile = this.extractMavenDependenciesFromFile(inputStream);
            for (DependencyInfo d : dependenciesFromFile) {
                dependencies.put(this.formatDependencyName(d), this.getRuntimeAndCompileVersion(d));
            }
        }
        catch (IOException e) {
            return dependencies;
        }
        return dependencies;
    }

    private InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions getRuntimeAndCompileVersion(DependencyInfo d) {
        URL url = (URL)this.propertiesUrlProvider.apply((Object)d);
        if (url == null) {
            return new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions(UNVERIFIED_RUNTIME_VERSION, d.getVersion(), d.isOptional());
        }
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (IOException e) {
            return new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions(UNVERIFIED_RUNTIME_VERSION, d.getVersion(), d.isOptional());
        }
        Object version = properties.get("version");
        if (version == null) {
            return new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions(UNVERIFIED_RUNTIME_VERSION, d.getVersion(), d.isOptional());
        }
        return new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions(version.toString(), d.getVersion(), d.isOptional());
    }

    private String formatDependencyName(DependencyInfo d) {
        return String.format("%s:%s", d.getGroupId(), d.getArtifactId());
    }

    private List<DependencyInfo> extractMavenDependenciesFromFile(InputStream inputStream) throws IOException {
        String line;
        ArrayList<DependencyInfo> dependenciesFromFile = new ArrayList<DependencyInfo>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, Charsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if (!this.lineWithDependencyInfo(line)) continue;
            dependenciesFromFile.add(this.extractDependencyFromLine(line.trim()));
        }
        return dependenciesFromFile;
    }

    private DependencyInfo extractDependencyFromLine(String line) {
        String[] split = DEPENDENCY_SPLIT_REGEX.split(line);
        if (split.length == 6) {
            return new DependencyInfo(split[0], split[1], split[4], this.checkIsOptional(split[5]));
        }
        return new DependencyInfo(split[0], split[1], split[3], this.checkIsOptional(split[4]));
    }

    private boolean checkIsOptional(String scope) {
        return scope.contains("(optional)");
    }

    private boolean lineWithDependencyInfo(String line) {
        return !line.equals(MAVEN_IGNORE_LINE) && !line.isEmpty();
    }

    private InsightsSchema.InsightsPlatformInfo.CPUS getCpuInfo() {
        int numberOfProcessors = Runtime.getRuntime().availableProcessors();
        String model = Native.isPlatformAvailable() ? Native.getCPU() : UNKNOWN;
        return new InsightsSchema.InsightsPlatformInfo.CPUS(numberOfProcessors, model);
    }

    private InsightsSchema.InsightsPlatformInfo.OS getOsInfo() {
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String osArch = System.getProperty("os.arch");
        return new InsightsSchema.InsightsPlatformInfo.OS(osName, osVersion, osArch);
    }

    static class DependencyInfo {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private boolean optional;

        DependencyInfo(String groupId, String artifactId, String version, boolean optional) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.optional = optional;
        }

        String getGroupId() {
            return this.groupId;
        }

        String getArtifactId() {
            return this.artifactId;
        }

        String getVersion() {
            return this.version;
        }

        boolean isOptional() {
            return this.optional;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            DependencyInfo that = (DependencyInfo)other;
            return MoreObjects.equal(this.groupId, that.groupId) && MoreObjects.equal(this.artifactId, that.artifactId) && MoreObjects.equal(this.version, that.version) && MoreObjects.equal(this.optional, that.optional);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.groupId, this.artifactId, this.version, this.optional);
        }

        public String toString() {
            return "DependencyInfo{groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", optional=" + this.optional + '}';
        }
    }
}

