/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.utils.MoreObjects;
import com.datastax.shaded.jackson.annotation.JsonCreator;
import com.datastax.shaded.jackson.annotation.JsonIgnoreProperties;
import com.datastax.shaded.jackson.annotation.JsonInclude;
import com.datastax.shaded.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.Set;

class InsightsSchema {
    InsightsSchema() {
    }

    static class SSL {
        @JsonProperty(value="enabled")
        final boolean enabled;

        @JsonCreator
        SSL(@JsonProperty(value="enabled") boolean enabled) {
            this.enabled = enabled;
        }

        boolean isEnabled() {
            return this.enabled;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            SSL that = (SSL)other;
            return MoreObjects.equal(this.enabled, that.enabled);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.enabled);
        }
    }

    static class SpeculativeExecutionInfo {
        @JsonProperty(value="type")
        final String type;
        @JsonProperty(value="options")
        final Map<String, Object> options;
        @JsonProperty(value="namespace")
        final String namespace;

        @JsonCreator
        SpeculativeExecutionInfo(@JsonProperty(value="type") String type, @JsonProperty(value="namespace") String namespace, @JsonProperty(value="options") Map<String, Object> options) {
            this.type = type;
            this.namespace = namespace;
            this.options = options;
        }

        String getType() {
            return this.type;
        }

        Map<String, Object> getOptions() {
            return this.options;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            SpeculativeExecutionInfo that = (SpeculativeExecutionInfo)other;
            return MoreObjects.equal(this.type, that.type) && MoreObjects.equal(this.options, that.options) && MoreObjects.equal(this.namespace, that.namespace);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.type, this.options, this.namespace);
        }

        public String toString() {
            return "SpeculativeExecutionInfo{type='" + this.type + '\'' + ", options=" + this.options + ", namespace='" + this.namespace + '\'' + '}';
        }
    }

    static class SessionStateForNode {
        @JsonProperty(value="connections")
        private final Integer connections;
        @JsonProperty(value="inFlightQueries")
        private final Integer inFlightQueries;

        @JsonCreator
        SessionStateForNode(@JsonProperty(value="connections") Integer connections, @JsonProperty(value="inFlightQueries") Integer inFlightQueries) {
            this.connections = connections;
            this.inFlightQueries = inFlightQueries;
        }

        Integer getConnections() {
            return this.connections;
        }

        Integer getInFlightQueries() {
            return this.inFlightQueries;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            SessionStateForNode that = (SessionStateForNode)other;
            return MoreObjects.equal(this.connections, that.connections) && MoreObjects.equal(this.inFlightQueries, that.inFlightQueries);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.connections, this.inFlightQueries);
        }

        public String toString() {
            return "SessionStateForNode{connections=" + this.connections + ", inFlightQueries=" + this.inFlightQueries + '}';
        }
    }

    static class ReconnectionPolicyInfo {
        @JsonProperty(value="type")
        final String type;
        @JsonProperty(value="options")
        final Map<String, Object> options;
        @JsonProperty(value="namespace")
        private final String namespace;

        @JsonCreator
        ReconnectionPolicyInfo(@JsonProperty(value="type") String type, @JsonProperty(value="namespace") String namespace, @JsonProperty(value="options") Map<String, Object> options) {
            this.type = type;
            this.namespace = namespace;
            this.options = options;
        }

        String getType() {
            return this.type;
        }

        Map<String, Object> getOptions() {
            return this.options;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            ReconnectionPolicyInfo that = (ReconnectionPolicyInfo)other;
            return MoreObjects.equal(this.type, that.type) && MoreObjects.equal(this.options, that.options) && MoreObjects.equal(this.namespace, that.namespace);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.type, this.options, this.namespace);
        }
    }

    static enum InsightType {
        EVENT,
        GAUGE,
        COUNTER,
        HISTOGRAM,
        TIMER,
        METER,
        LOG;

    }

    static class InsightsStatusData {
        @JsonProperty(value="clientId")
        private final String clientId;
        @JsonProperty(value="sessionId")
        private final String sessionId;
        @JsonProperty(value="controlConnection")
        private final String controlConnection;
        @JsonProperty(value="connectedNodes")
        private final Map<String, SessionStateForNode> connectedNodes;

        @JsonCreator
        InsightsStatusData(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="sessionId") String sessionId, @JsonProperty(value="controlConnection") String controlConnection, @JsonProperty(value="connectedNodes") Map<String, SessionStateForNode> connectedNodes) {
            this.clientId = clientId;
            this.sessionId = sessionId;
            this.controlConnection = controlConnection;
            this.connectedNodes = connectedNodes;
        }

        String getClientId() {
            return this.clientId;
        }

        String getSessionId() {
            return this.sessionId;
        }

        String getControlConnection() {
            return this.controlConnection;
        }

        Map<String, SessionStateForNode> getConnectedNodes() {
            return this.connectedNodes;
        }

        public String toString() {
            return "InsightsStatusData{clientId='" + this.clientId + '\'' + ", sessionId='" + this.sessionId + '\'' + ", controlConnection=" + this.controlConnection + ", connectedNodes=" + this.connectedNodes + '}';
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            InsightsStatusData that = (InsightsStatusData)other;
            return MoreObjects.equal(this.clientId, that.clientId) && MoreObjects.equal(this.sessionId, that.sessionId) && MoreObjects.equal(this.controlConnection, that.controlConnection) && MoreObjects.equal(this.connectedNodes, that.connectedNodes);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.clientId, this.sessionId, this.connectedNodes, this.connectedNodes);
        }

        static Builder builder() {
            return new Builder();
        }

        static class Builder {
            private String clientId;
            private String sessionId;
            private String controlConnection;
            private Map<String, SessionStateForNode> connectedNodes;

            Builder() {
            }

            Builder withClientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            Builder withSessionId(String id) {
                this.sessionId = id;
                return this;
            }

            Builder withControlConnection(String controlConnection) {
                this.controlConnection = controlConnection;
                return this;
            }

            Builder withConnectedNodes(Map<String, SessionStateForNode> connectedNodes) {
                this.connectedNodes = connectedNodes;
                return this;
            }

            InsightsStatusData build() {
                return new InsightsStatusData(this.clientId, this.sessionId, this.controlConnection, this.connectedNodes);
            }
        }
    }

    static class InsightsStartupData {
        @JsonProperty(value="clientId")
        private final String clientId;
        @JsonProperty(value="sessionId")
        private final String sessionId;
        @JsonProperty(value="applicationName")
        private final String applicationName;
        @JsonProperty(value="applicationVersion")
        private final String applicationVersion;
        @JsonProperty(value="contactPoints")
        private final Map<String, List<String>> contactPoints;
        @JsonProperty(value="initialControlConnection")
        private final String initialControlConnection;
        @JsonProperty(value="protocolVersion")
        private final int protocolVersion;
        @JsonProperty(value="localAddress")
        private final String localAddress;
        @JsonProperty(value="executionProfiles")
        private final Map<String, SpecificExecutionProfile> executionProfiles;
        @JsonProperty(value="poolSizeByHostDistance")
        private final PoolSizeByHostDistance poolSizeByHostDistance;
        @JsonProperty(value="heartbeatInterval")
        private final long heartbeatInterval;
        @JsonProperty(value="compression")
        private final ProtocolOptions.Compression compression;
        @JsonProperty(value="reconnectionPolicy")
        private final ReconnectionPolicyInfo reconnectionPolicy;
        @JsonProperty(value="ssl")
        private final SSL ssl;
        @JsonProperty(value="authProvider")
        private final AuthProviderType authProvider;
        @JsonProperty(value="otherOptions")
        private final Map<String, Object> otherOptions;
        @JsonProperty(value="configAntiPatterns")
        private final Map<String, String> configAntiPatterns;
        @JsonProperty(value="periodicStatusInterval")
        private final long periodicStatusInterval;
        @JsonProperty(value="platformInfo")
        private final InsightsPlatformInfo platformInfo;
        @JsonProperty(value="hostName")
        private final String hostName;
        @JsonProperty(value="driverName")
        private String driverName;
        @JsonProperty(value="applicationNameWasGenerated")
        private boolean applicationNameWasGenerated;
        @JsonProperty(value="driverVersion")
        private String driverVersion;
        @JsonProperty(value="dataCenters")
        private Set<String> dataCenters;

        @JsonCreator
        InsightsStartupData(@JsonProperty(value="clientId") String clientId, @JsonProperty(value="sessionId") String sessionId, @JsonProperty(value="applicationName") String applicationName, @JsonProperty(value="applicationVersion") String applicationVersion, @JsonProperty(value="contactPoints") Map<String, List<String>> contactPoints, @JsonProperty(value="initialControlConnection") String initialControlConnection, @JsonProperty(value="protocolVersion") int protocolVersion, @JsonProperty(value="localAddress") String localAddress, @JsonProperty(value="executionProfiles") Map<String, SpecificExecutionProfile> executionProfiles, @JsonProperty(value="poolSizeByHostDistance") PoolSizeByHostDistance poolSizeByHostDistance, @JsonProperty(value="heartbeatInterval") long heartbeatInterval, @JsonProperty(value="compression") ProtocolOptions.Compression compression, @JsonProperty(value="reconnectionPolicy") ReconnectionPolicyInfo reconnectionPolicy, @JsonProperty(value="ssl") SSL ssl, @JsonProperty(value="authProvider") AuthProviderType authProvider, @JsonProperty(value="otherOptions") Map<String, Object> otherOptions, @JsonProperty(value="configAntiPatterns") Map<String, String> configAntiPatterns, @JsonProperty(value="periodicStatusInterval") long periodicStatusInterval, @JsonProperty(value="platformInfo") InsightsPlatformInfo platformInfo, @JsonProperty(value="hostName") String hostName, @JsonProperty(value="driverName") String driverName, @JsonProperty(value="applicationNameWasGenerated") boolean applicationNameWasGenerated, @JsonProperty(value="driverVersion") String driverVersion, @JsonProperty(value="dataCenters") Set<String> dataCenters) {
            this.clientId = clientId;
            this.sessionId = sessionId;
            this.applicationName = applicationName;
            this.applicationVersion = applicationVersion;
            this.contactPoints = contactPoints;
            this.initialControlConnection = initialControlConnection;
            this.protocolVersion = protocolVersion;
            this.localAddress = localAddress;
            this.executionProfiles = executionProfiles;
            this.poolSizeByHostDistance = poolSizeByHostDistance;
            this.heartbeatInterval = heartbeatInterval;
            this.compression = compression;
            this.reconnectionPolicy = reconnectionPolicy;
            this.ssl = ssl;
            this.authProvider = authProvider;
            this.otherOptions = otherOptions;
            this.configAntiPatterns = configAntiPatterns;
            this.periodicStatusInterval = periodicStatusInterval;
            this.platformInfo = platformInfo;
            this.hostName = hostName;
            this.driverName = driverName;
            this.applicationNameWasGenerated = applicationNameWasGenerated;
            this.driverVersion = driverVersion;
            this.dataCenters = dataCenters;
        }

        String getClientId() {
            return this.clientId;
        }

        String getSessionId() {
            return this.sessionId;
        }

        String getApplicationName() {
            return this.applicationName;
        }

        String getApplicationVersion() {
            return this.applicationVersion;
        }

        Map<String, List<String>> getContactPoints() {
            return this.contactPoints;
        }

        String getInitialControlConnection() {
            return this.initialControlConnection;
        }

        int getProtocolVersion() {
            return this.protocolVersion;
        }

        String getLocalAddress() {
            return this.localAddress;
        }

        Map<String, SpecificExecutionProfile> getExecutionProfiles() {
            return this.executionProfiles;
        }

        PoolSizeByHostDistance getPoolSizeByHostDistance() {
            return this.poolSizeByHostDistance;
        }

        long getHeartbeatInterval() {
            return this.heartbeatInterval;
        }

        ProtocolOptions.Compression getCompression() {
            return this.compression;
        }

        ReconnectionPolicyInfo getReconnectionPolicy() {
            return this.reconnectionPolicy;
        }

        SSL getSsl() {
            return this.ssl;
        }

        AuthProviderType getAuthProvider() {
            return this.authProvider;
        }

        Map<String, Object> getOtherOptions() {
            return this.otherOptions;
        }

        Map<String, String> getConfigAntiPatterns() {
            return this.configAntiPatterns;
        }

        long getPeriodicStatusInterval() {
            return this.periodicStatusInterval;
        }

        InsightsPlatformInfo getPlatformInfo() {
            return this.platformInfo;
        }

        String getHostName() {
            return this.hostName;
        }

        String getDriverName() {
            return this.driverName;
        }

        boolean isApplicationNameWasGenerated() {
            return this.applicationNameWasGenerated;
        }

        String getDriverVersion() {
            return this.driverVersion;
        }

        Set<String> getDataCenters() {
            return this.dataCenters;
        }

        static Builder builder() {
            return new Builder();
        }

        static class Builder {
            private String clientId;
            private String sessionId;
            private String applicationName;
            private String applicationVersion;
            private Map<String, List<String>> contactPoints;
            private String initialControlConnection;
            private int protocolVersion;
            private String localAddress;
            private Map<String, SpecificExecutionProfile> executionProfiles;
            private PoolSizeByHostDistance poolSizeByHostDistance;
            private long heartbeatInterval;
            private ProtocolOptions.Compression compression;
            private ReconnectionPolicyInfo reconnectionPolicy;
            private SSL ssl;
            private AuthProviderType authProvider;
            private Map<String, Object> otherOptions;
            private Map<String, String> configAntiPatterns;
            private long periodicStatusInterval;
            private InsightsPlatformInfo platformInfo;
            private String hostName;
            private String driverName;
            private String driverVersion;
            private boolean applicationNameWasGenerated;
            private Set<String> dataCenters;

            Builder() {
            }

            InsightsStartupData build() {
                return new InsightsStartupData(this.clientId, this.sessionId, this.applicationName, this.applicationVersion, this.contactPoints, this.initialControlConnection, this.protocolVersion, this.localAddress, this.executionProfiles, this.poolSizeByHostDistance, this.heartbeatInterval, this.compression, this.reconnectionPolicy, this.ssl, this.authProvider, this.otherOptions, this.configAntiPatterns, this.periodicStatusInterval, this.platformInfo, this.hostName, this.driverName, this.applicationNameWasGenerated, this.driverVersion, this.dataCenters);
            }

            Builder withClientId(String clientId) {
                this.clientId = clientId;
                return this;
            }

            Builder withSessionId(String id) {
                this.sessionId = id;
                return this;
            }

            Builder withApplicationName(String applicationName) {
                this.applicationName = applicationName;
                return this;
            }

            Builder withApplicationVersion(String applicationVersion) {
                this.applicationVersion = applicationVersion;
                return this;
            }

            Builder withContactPoints(Map<String, List<String>> contactPoints) {
                this.contactPoints = contactPoints;
                return this;
            }

            Builder withInitialControlConnection(String inetSocketAddress) {
                this.initialControlConnection = inetSocketAddress;
                return this;
            }

            Builder withProtocolVersion(int protocolVersion) {
                this.protocolVersion = protocolVersion;
                return this;
            }

            Builder withLocalAddress(String localAddress) {
                this.localAddress = localAddress;
                return this;
            }

            Builder withExecutionProfiles(Map<String, SpecificExecutionProfile> executionProfiles) {
                this.executionProfiles = executionProfiles;
                return this;
            }

            Builder withPoolSizeByHostDistance(PoolSizeByHostDistance poolSizeByHostDistance) {
                this.poolSizeByHostDistance = poolSizeByHostDistance;
                return this;
            }

            Builder withHeartbeatInterval(long heartbeatInterval) {
                this.heartbeatInterval = heartbeatInterval;
                return this;
            }

            Builder withCompression(ProtocolOptions.Compression compression) {
                this.compression = compression;
                return this;
            }

            Builder withReconnectionPolicy(ReconnectionPolicyInfo reconnectionPolicy) {
                this.reconnectionPolicy = reconnectionPolicy;
                return this;
            }

            Builder withSsl(SSL ssl) {
                this.ssl = ssl;
                return this;
            }

            Builder withAuthProvider(AuthProviderType authProvider) {
                this.authProvider = authProvider;
                return this;
            }

            Builder withOtherOptions(Map<String, Object> otherOptions) {
                this.otherOptions = otherOptions;
                return this;
            }

            Builder withConfigAntiPatterns(Map<String, String> configAntiPatterns) {
                this.configAntiPatterns = configAntiPatterns;
                return this;
            }

            Builder withPeriodicStatusInterval(long periodicStatusInterval) {
                this.periodicStatusInterval = periodicStatusInterval;
                return this;
            }

            Builder withPlatformInfo(InsightsPlatformInfo insightsPlatformInfo) {
                this.platformInfo = insightsPlatformInfo;
                return this;
            }

            Builder withHostName(String hostName) {
                this.hostName = hostName;
                return this;
            }

            Builder withDriverName(String driverName) {
                this.driverName = driverName;
                return this;
            }

            Builder withDriverVersion(String driverVersion) {
                this.driverVersion = driverVersion;
                return this;
            }

            Builder withApplicationNameWasGenerated(boolean applicationNameWasGenerated) {
                this.applicationNameWasGenerated = applicationNameWasGenerated;
                return this;
            }

            Builder withDataCenters(Set<String> dataCenters) {
                this.dataCenters = dataCenters;
                return this;
            }
        }
    }

    static class InsightsPlatformInfo {
        @JsonProperty(value="os")
        private final OS os;
        @JsonProperty(value="cpus")
        private CPUS cpus;
        @JsonProperty(value="runtime")
        private Map<String, Map<String, RuntimeAndCompileTimeVersions>> runtime;

        @JsonCreator
        InsightsPlatformInfo(@JsonProperty(value="os") OS os, @JsonProperty(value="cpus") CPUS cpus, @JsonProperty(value="runtime") Map<String, Map<String, RuntimeAndCompileTimeVersions>> runtime) {
            this.os = os;
            this.cpus = cpus;
            this.runtime = runtime;
        }

        OS getOs() {
            return this.os;
        }

        CPUS getCpus() {
            return this.cpus;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            InsightsPlatformInfo that = (InsightsPlatformInfo)other;
            return MoreObjects.equal(this.os, that.os) && MoreObjects.equal(this.cpus, that.cpus) && MoreObjects.equal(this.runtime, that.runtime);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.os, this.cpus, this.runtime);
        }

        Map<String, Map<String, RuntimeAndCompileTimeVersions>> getRuntime() {
            return this.runtime;
        }

        static class RuntimeAndCompileTimeVersions {
            @JsonProperty(value="runtimeVersion")
            private final String runtimeVersion;
            @JsonProperty(value="compileVersion")
            private final String compileVersion;
            @JsonProperty(value="optional")
            private final boolean optional;

            @JsonCreator
            RuntimeAndCompileTimeVersions(@JsonProperty(value="runtimeVersion") String runtimeVersion, @JsonProperty(value="compileVersion") String compileVersion, @JsonProperty(value="optional") boolean optional) {
                this.runtimeVersion = runtimeVersion;
                this.compileVersion = compileVersion;
                this.optional = optional;
            }

            String getRuntimeVersion() {
                return this.runtimeVersion;
            }

            String getCompileVersion() {
                return this.compileVersion;
            }

            public boolean isOptional() {
                return this.optional;
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                RuntimeAndCompileTimeVersions that = (RuntimeAndCompileTimeVersions)other;
                return MoreObjects.equal(this.runtimeVersion, that.runtimeVersion) && MoreObjects.equal(this.compileVersion, that.compileVersion) && MoreObjects.equal(this.optional, that.optional);
            }

            public int hashCode() {
                return MoreObjects.hashCode(this.runtimeVersion, this.compileVersion, this.optional);
            }

            public String toString() {
                return "RuntimeAndCompileTimeVersions{runtimeVersion='" + this.runtimeVersion + '\'' + ", compileVersion='" + this.compileVersion + '\'' + ", optional=" + this.optional + '}';
            }
        }

        static class CPUS {
            @JsonProperty(value="length")
            private final int length;
            @JsonProperty(value="model")
            private final String model;

            @JsonCreator
            CPUS(@JsonProperty(value="length") int length, @JsonProperty(value="model") String model) {
                this.length = length;
                this.model = model;
            }

            int getLength() {
                return this.length;
            }

            String getModel() {
                return this.model;
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                CPUS that = (CPUS)other;
                return MoreObjects.equal(this.length, that.length) && MoreObjects.equal(this.model, that.model);
            }

            public int hashCode() {
                return MoreObjects.hashCode(this.length, this.model);
            }
        }

        static class OS {
            @JsonProperty(value="name")
            private final String name;
            @JsonProperty(value="version")
            private final String version;
            @JsonProperty(value="arch")
            private final String arch;

            @JsonCreator
            OS(@JsonProperty(value="name") String name, @JsonProperty(value="version") String version, @JsonProperty(value="arch") String arch) {
                this.name = name;
                this.version = version;
                this.arch = arch;
            }

            String getName() {
                return this.name;
            }

            String getVersion() {
                return this.version;
            }

            String getArch() {
                return this.arch;
            }

            public boolean equals(Object other) {
                if (other == null || other.getClass() != this.getClass()) {
                    return false;
                }
                OS that = (OS)other;
                return MoreObjects.equal(this.name, that.name) && MoreObjects.equal(this.version, that.version) && MoreObjects.equal(this.arch, that.arch);
            }

            public int hashCode() {
                return MoreObjects.hashCode(this.name, this.version, this.arch);
            }
        }
    }

    static class LoadBalancingInfo {
        @JsonProperty(value="type")
        private final String type;
        @JsonProperty(value="options")
        private final Map<String, Object> options;
        @JsonProperty(value="namespace")
        private final String namespace;

        @JsonCreator
        LoadBalancingInfo(@JsonProperty(value="type") String type, @JsonProperty(value="namespace") String namespace, @JsonProperty(value="options") Map<String, Object> options) {
            this.type = type;
            this.namespace = namespace;
            this.options = options;
        }

        String getType() {
            return this.type;
        }

        Map<String, Object> getOptions() {
            return this.options;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            LoadBalancingInfo that = (LoadBalancingInfo)other;
            return MoreObjects.equal(this.type, that.type) && MoreObjects.equal(this.options, that.options) && MoreObjects.equal(this.namespace, that.namespace);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.type, this.options, this.namespace);
        }

        public String toString() {
            return "LoadBalancingInfo{type='" + this.type + '\'' + ", options=" + this.options + ", namespace='" + this.namespace + '\'' + '}';
        }
    }

    static class SpecificExecutionProfile {
        @JsonProperty(value="readTimeout")
        private final int readTimeout;
        @JsonProperty(value="loadBalancing")
        private final LoadBalancingInfo loadBalancing;
        @JsonProperty(value="speculativeExecution")
        private SpeculativeExecutionInfo speculativeExecution;
        @JsonProperty(value="consistency")
        private final String consistency;
        @JsonProperty(value="serialConsistency")
        private final String serialConsistency;
        @JsonProperty(value="graphOptions")
        private Map<String, Object> graphOptions;

        @JsonCreator
        SpecificExecutionProfile(@JsonProperty(value="readTimeout") int readTimeoutMillis, @JsonProperty(value="loadBalancing") LoadBalancingInfo loadBalancing, @JsonProperty(value="speculativeExecution") SpeculativeExecutionInfo speculativeExecutionInfo, @JsonProperty(value="consistency") String consistency, @JsonProperty(value="serialConsistency") String serialConsistency, @JsonProperty(value="graphOptions") Map<String, Object> graphOptions) {
            this.readTimeout = readTimeoutMillis;
            this.loadBalancing = loadBalancing;
            this.speculativeExecution = speculativeExecutionInfo;
            this.consistency = consistency;
            this.serialConsistency = serialConsistency;
            this.graphOptions = graphOptions;
        }

        int getReadTimeout() {
            return this.readTimeout;
        }

        LoadBalancingInfo getLoadBalancing() {
            return this.loadBalancing;
        }

        SpeculativeExecutionInfo getSpeculativeExecution() {
            return this.speculativeExecution;
        }

        String getConsistency() {
            return this.consistency;
        }

        String getSerialConsistency() {
            return this.serialConsistency;
        }

        Map<String, Object> getGraphOptions() {
            return this.graphOptions;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            SpecificExecutionProfile that = (SpecificExecutionProfile)other;
            return MoreObjects.equal(this.readTimeout, that.readTimeout) && MoreObjects.equal(this.loadBalancing, that.loadBalancing) && MoreObjects.equal(this.speculativeExecution, that.speculativeExecution) && MoreObjects.equal(this.consistency, that.consistency) && MoreObjects.equal(this.serialConsistency, that.serialConsistency) && MoreObjects.equal(this.graphOptions, that.graphOptions);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.readTimeout, this.loadBalancing, this.speculativeExecution, this.consistency, this.serialConsistency, this.graphOptions);
        }

        public String toString() {
            return "SpecificExecutionProfile{readTimeout=" + this.readTimeout + ", loadBalancing=" + this.loadBalancing + ", speculativeExecution=" + this.speculativeExecution + ", consistency='" + this.consistency + '\'' + ", serialConsistency='" + this.serialConsistency + '\'' + ", graphOptions=" + this.graphOptions + '}';
        }
    }

    static class PoolSizeByHostDistance {
        @JsonProperty(value="local")
        final int local;
        @JsonProperty(value="remote")
        final int remote;
        @JsonProperty(value="ignored")
        final int ignored;

        @JsonCreator
        PoolSizeByHostDistance(@JsonProperty(value="local") int local, @JsonProperty(value="remote") int remote, @JsonProperty(value="ignored") int ignored) {
            this.local = local;
            this.remote = remote;
            this.ignored = ignored;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            PoolSizeByHostDistance that = (PoolSizeByHostDistance)other;
            return MoreObjects.equal(this.local, that.local) && MoreObjects.equal(this.remote, that.remote) && MoreObjects.equal(this.ignored, that.ignored);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.local, this.remote, this.ignored);
        }
    }

    static class AuthProviderType {
        @JsonProperty(value="type")
        private final String type;
        @JsonProperty(value="namespace")
        private final String namespace;

        @JsonCreator
        AuthProviderType(@JsonProperty(value="type") String type, @JsonProperty(value="namespace") String namespace) {
            this.type = type;
            this.namespace = namespace;
        }

        String getType() {
            return this.type;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            AuthProviderType that = (AuthProviderType)other;
            return MoreObjects.equal(this.type, that.type) && MoreObjects.equal(this.namespace, that.namespace);
        }

        public int hashCode() {
            return MoreObjects.hashCode(this.type, this.namespace);
        }

        public String toString() {
            return "AuthProviderType{type='" + this.type + '\'' + ", namespace='" + this.namespace + '\'' + '}';
        }
    }

    static class InsightsMetadata {
        @JsonProperty(value="name")
        private final String name;
        @JsonProperty(value="timestamp")
        private final long timestamp;
        @JsonProperty(value="tags")
        private final Map<String, String> tags;
        @JsonProperty(value="insightType")
        private final InsightType insightType;
        @JsonProperty(value="insightMappingId")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        private String insightMappingId;

        @JsonCreator
        InsightsMetadata(@JsonProperty(value="name") String name, @JsonProperty(value="timestamp") long timestamp, @JsonProperty(value="tags") Map<String, String> tags, @JsonProperty(value="insightType") InsightType insightType, @JsonProperty(value="insightMappingId") String insightMappingId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"name is required");
            this.name = name;
            this.timestamp = timestamp;
            this.tags = tags;
            this.insightType = insightType;
            this.insightMappingId = insightMappingId;
        }

        public boolean equals(Object other) {
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            InsightsMetadata that = (InsightsMetadata)other;
            return MoreObjects.equal(this.name, that.name) && MoreObjects.equal(this.timestamp, that.timestamp) && MoreObjects.equal(this.tags, that.tags) && MoreObjects.equal((Object)this.insightType, (Object)that.insightType) && MoreObjects.equal(this.insightMappingId, that.insightMappingId);
        }

        public int hashCode() {
            return MoreObjects.hashCode(new Object[]{this.name, this.timestamp, this.tags, this.insightType, this.insightMappingId});
        }

        public String toString() {
            return "InsightsMetadata{name='" + this.name + '\'' + ", timestamp=" + this.timestamp + ", tags=" + this.tags + ", insightType=" + (Object)((Object)this.insightType) + ", insightMappingId=" + this.insightMappingId + '}';
        }

        String getName() {
            return this.name;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        Map<String, String> getTags() {
            return this.tags;
        }

        InsightType getInsightType() {
            return this.insightType;
        }

        String getInsightMappingId() {
            return this.insightMappingId;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    static class Insight<T> {
        @JsonProperty(value="metadata")
        private final InsightsMetadata metadata;
        @JsonProperty(value="data")
        private final T insightsData;

        @JsonCreator
        Insight(@JsonProperty(value="metadata") InsightsMetadata metadata, @JsonProperty(value="data") T data) {
            this.metadata = metadata;
            this.insightsData = data;
        }

        InsightsMetadata getMetadata() {
            return this.metadata;
        }

        T getInsightsData() {
            return this.insightsData;
        }

        public String toString() {
            return "Insight{metadata=" + this.metadata + ", insightsData=" + this.insightsData + '}';
        }
    }
}

