/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core.exceptions;

import java.net.InetAddress;
import java.net.InetSocketAddress;

/** Error during a truncation operation. */
public class TruncateException extends QueryExecutionException implements CoordinatorException {

  private static final long serialVersionUID = 0;

  private final InetSocketAddress address;

  public TruncateException(InetSocketAddress address, String msg) {
    super(msg);
    this.address = address;
  }

  private TruncateException(InetSocketAddress address, String msg, Throwable cause) {
    super(msg, cause);
    this.address = address;
  }

  /** {@inheritDoc} */
  @Override
  public InetAddress getHost() {
    return address != null ? address.getAddress() : null;
  }

  /** {@inheritDoc} */
  @Override
  public InetSocketAddress getAddress() {
    return address;
  }

  @Override
  public TruncateException copy() {
    return new TruncateException(getAddress(), getMessage(), this);
  }
}
