/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

import static com.datastax.driver.core.InsightsSchema.*;
import static com.datastax.driver.core.PackageUtil.getNamespace;

import com.datastax.driver.core.policies.ConstantSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.PercentileSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.SpeculativeExecutionPolicy;
import java.util.HashMap;
import java.util.Map;

class SpeculativeExecutionInfoFinder {
  SpeculativeExecutionInfo getSpeculativeExecutionInfo(
      SpeculativeExecutionPolicy speculativeExecutionPolicy) {
    String type = speculativeExecutionPolicy.getClass().getSimpleName();
    String namespace = getNamespace(speculativeExecutionPolicy.getClass());

    Map<String, Object> options = new HashMap<String, Object>();

    if (speculativeExecutionPolicy instanceof ConstantSpeculativeExecutionPolicy) {
      ConstantSpeculativeExecutionPolicy constantSpeculativeExecutionPolicy =
          (ConstantSpeculativeExecutionPolicy) speculativeExecutionPolicy;
      options.put(
          "constantDelayMillis", constantSpeculativeExecutionPolicy.getConstantDelayMillis());
      options.put(
          "maxSpeculativeExecutions",
          constantSpeculativeExecutionPolicy.getMaxSpeculativeExecutions());
    } else if (speculativeExecutionPolicy instanceof PercentileSpeculativeExecutionPolicy) {
      PercentileSpeculativeExecutionPolicy percentileSpeculativeExecutionPolicy =
          (PercentileSpeculativeExecutionPolicy) speculativeExecutionPolicy;
      options.put(
          "maxSpeculativeExecutions",
          percentileSpeculativeExecutionPolicy.getMaxSpeculativeExecutions());
      options.put("percentile", percentileSpeculativeExecutionPolicy.getPercentile());
    }
    return new SpeculativeExecutionInfo(type, namespace, options);
  }
}
