/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

import static com.datastax.driver.core.InsightsSchema.ReconnectionPolicyInfo;
import static com.datastax.driver.core.PackageUtil.getNamespace;

import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import java.util.HashMap;
import java.util.Map;

class ReconnectionPolicyInfoFinder {
  ReconnectionPolicyInfo getReconnectionPolicyInfo(ReconnectionPolicy reconnectionPolicy) {
    String type = reconnectionPolicy.getClass().getSimpleName();
    String namespace = getNamespace(reconnectionPolicy.getClass());
    Map<String, Object> options = new HashMap<String, Object>();
    if (reconnectionPolicy instanceof ConstantReconnectionPolicy) {
      ConstantReconnectionPolicy constantReconnectionPolicy =
          (ConstantReconnectionPolicy) reconnectionPolicy;
      options.put("delayMs", constantReconnectionPolicy.getConstantDelayMs());
    } else if (reconnectionPolicy instanceof ExponentialReconnectionPolicy) {
      ExponentialReconnectionPolicy exponentialReconnectionPolicy =
          (ExponentialReconnectionPolicy) reconnectionPolicy;
      options.put("maxDelayMs", exponentialReconnectionPolicy.getMaxDelayMs());
      options.put("baseDelayMs", exponentialReconnectionPolicy.getBaseDelayMs());
      options.put("maxAttempts", exponentialReconnectionPolicy.getMaxAttempts());
    }
    return new ReconnectionPolicyInfo(type, namespace, options);
  }
}
