/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

public class MetricsUtil {

  public static String hostMetricName(String prefix, Host host) {
    StringBuilder result = new StringBuilder(prefix);
    boolean first = true;
    for (byte b : host.getSocketAddress().getAddress().getAddress()) {
      if (first) {
        first = false;
      } else {
        result.append('_');
      }
      result.append(b & 0xFF);
    }
    return result.toString();
  }
}
