/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

import java.util.Set;

class InsightsSupportVerifier {
  private static final VersionNumber minDse6Version = VersionNumber.parse("6.0.5");
  private static final VersionNumber minDse51Version = VersionNumber.parse("5.1.13");
  private static final VersionNumber dse600Version = VersionNumber.parse("6.0.0");

  static boolean supportsInsights(Cluster cluster) {
    Set<Host> allHosts = cluster.getMetadata().getAllHosts();
    if (allHosts.isEmpty()) return false;

    for (Host host : allHosts) {
      VersionNumber dseVersion = host.getDseVersion();
      if (dseVersion == null) return false;
      if (!(dseVersion.compareTo(minDse6Version) >= 0
          || (dseVersion.compareTo(dse600Version) < 0
              && dseVersion.compareTo(minDse51Version) >= 0))) {
        return false;
      }
    }
    return true;
  }
}
