/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

/** {@link InsightsClient} options. */
public class InsightsOptions {

  private boolean monitorReportingEnabled;

  /**
   * Creates a new {@code InsightsOptions} object with default value (monitorReportingEnabled
   * enabled).
   */
  InsightsOptions() {
    this(true);
  }

  /**
   * Creates a new {@code InsightsOptions} object.
   *
   * @param monitorReportingEnabled whether to enable sending Insights events or not.
   */
  InsightsOptions(boolean monitorReportingEnabled) {

    this.monitorReportingEnabled = monitorReportingEnabled;
  }

  /**
   * Returns whether Insights monitoring is enabled.
   *
   * @return whether Insights monitoring is enabled.
   */
  public boolean isMonitorReportingEnabled() {
    return monitorReportingEnabled;
  }
}
