/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

class InsightsConfiguration {
  private final boolean monitorReportingEnabled;
  private final long statusEventDelayMillis;

  InsightsConfiguration(boolean monitorReportingEnabled, Long statusEventDelayMillis) {
    this.monitorReportingEnabled = monitorReportingEnabled;
    this.statusEventDelayMillis = statusEventDelayMillis;
  }

  boolean isMonitorReportingEnabled() {
    return monitorReportingEnabled;
  }

  long getStatusEventDelayMillis() {
    return statusEventDelayMillis;
  }
}
