/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

import java.util.HashSet;
import java.util.Set;

class DataCentersFinder {
  Set<String> getDataCenters(Cluster cluster) {
    int remoteConnectionsLength =
        cluster
            .getConfiguration()
            .getPoolingOptions()
            .getCoreConnectionsPerHost(HostDistance.REMOTE);
    Set<String> dataCenters = new HashSet<String>();

    for (Host h : cluster.getMetadata().getAllHosts()) {

      HostDistance distance =
          cluster.getConfiguration().getPolicies().getLoadBalancingPolicy().distance(h);
      if (distance.equals(HostDistance.LOCAL)
          || (distance.equals(HostDistance.REMOTE) && remoteConnectionsLength > 0)) {
        dataCenters.add(h.getDatacenter());
      }
    }
    return dataCenters;
  }

  String getLocalDataCenter(Cluster cluster) {
    for (Host h : cluster.getMetadata().getAllHosts()) {
      HostDistance distance =
          cluster.getConfiguration().getPolicies().getLoadBalancingPolicy().distance(h);
      if (distance.equals(HostDistance.LOCAL)) {
        return h.getDatacenter();
      }
    }
    return null;
  }
}
