/*
 * Copyright DataStax, Inc.
 *
 * This software can be used solely with DataStax Enterprise. Please consult the license at
 * http://www.datastax.com/terms/datastax-dse-driver-license-terms
 */
package com.datastax.driver.core;

/**
 * Special exception that gets emitted to {@link LatencyTracker}s with the latencies of cancelled
 * speculative executions. This allows those trackers to choose whether to ignore those latencies or
 * not.
 */
class CancelledSpeculativeExecutionException extends Exception {

  static CancelledSpeculativeExecutionException INSTANCE =
      new CancelledSpeculativeExecutionException();

  private CancelledSpeculativeExecutionException() {
    super();
  }
}
