/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.jackson.databind.ext;

import com.datastax.shaded.jackson.core.JsonGenerationException;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.databind.JavaType;
import com.datastax.shaded.jackson.databind.JsonMappingException;
import com.datastax.shaded.jackson.databind.JsonNode;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.datastax.shaded.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class DOMSerializer
extends StdSerializer<Node> {
    protected final DOMImplementationLS _domImpl;

    public DOMSerializer() {
        super(Node.class);
        DOMImplementationRegistry registry;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not instantiate DOMImplementationRegistry: " + e.getMessage(), e);
        }
        this._domImpl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
    }

    @Override
    public void serialize(Node value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        if (this._domImpl == null) {
            throw new IllegalStateException("Could not find DOM LS");
        }
        LSSerializer writer = this._domImpl.createLSSerializer();
        jgen.writeString(writer.writeToString(value));
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        return this.createSchemaNode("string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        if (visitor != null) {
            visitor.expectAnyFormat(typeHint);
        }
    }
}

