/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.codehaus.jackson.JsonFactory;
import com.datastax.shaded.codehaus.jackson.JsonParser;
import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.MapGeometry;
import com.datastax.shaded.esri.Operator;
import com.datastax.shaded.esri.OperatorBoundaryLocal;
import com.datastax.shaded.esri.OperatorBufferLocal;
import com.datastax.shaded.esri.OperatorClipLocal;
import com.datastax.shaded.esri.OperatorContainsLocal;
import com.datastax.shaded.esri.OperatorConvexHullLocal;
import com.datastax.shaded.esri.OperatorCrossesLocal;
import com.datastax.shaded.esri.OperatorCutLocal;
import com.datastax.shaded.esri.OperatorDensifyByLengthLocal;
import com.datastax.shaded.esri.OperatorDifferenceLocal;
import com.datastax.shaded.esri.OperatorDisjointLocal;
import com.datastax.shaded.esri.OperatorDistanceLocal;
import com.datastax.shaded.esri.OperatorEqualsLocal;
import com.datastax.shaded.esri.OperatorExportToESRIShape;
import com.datastax.shaded.esri.OperatorExportToESRIShapeLocal;
import com.datastax.shaded.esri.OperatorExportToGeoJsonLocal;
import com.datastax.shaded.esri.OperatorExportToJson;
import com.datastax.shaded.esri.OperatorExportToJsonLocal;
import com.datastax.shaded.esri.OperatorExportToWkbLocal;
import com.datastax.shaded.esri.OperatorExportToWkt;
import com.datastax.shaded.esri.OperatorExportToWktLocal;
import com.datastax.shaded.esri.OperatorFactory;
import com.datastax.shaded.esri.OperatorGeneralizeLocal;
import com.datastax.shaded.esri.OperatorGeodesicBufferLocal;
import com.datastax.shaded.esri.OperatorGeodeticAreaLocal;
import com.datastax.shaded.esri.OperatorGeodeticDensifyLocal;
import com.datastax.shaded.esri.OperatorGeodeticLengthLocal;
import com.datastax.shaded.esri.OperatorImportFromESRIShape;
import com.datastax.shaded.esri.OperatorImportFromESRIShapeLocal;
import com.datastax.shaded.esri.OperatorImportFromGeoJsonLocal;
import com.datastax.shaded.esri.OperatorImportFromJson;
import com.datastax.shaded.esri.OperatorImportFromJsonLocal;
import com.datastax.shaded.esri.OperatorImportFromWkbLocal;
import com.datastax.shaded.esri.OperatorImportFromWkt;
import com.datastax.shaded.esri.OperatorImportFromWktLocal;
import com.datastax.shaded.esri.OperatorIntersectionLocal;
import com.datastax.shaded.esri.OperatorIntersectsLocal;
import com.datastax.shaded.esri.OperatorOffsetLocal;
import com.datastax.shaded.esri.OperatorOverlapsLocal;
import com.datastax.shaded.esri.OperatorProjectLocal;
import com.datastax.shaded.esri.OperatorProximity2DLocal;
import com.datastax.shaded.esri.OperatorRelateLocal;
import com.datastax.shaded.esri.OperatorShapePreservingDensifyLocal;
import com.datastax.shaded.esri.OperatorSimplifyLocal;
import com.datastax.shaded.esri.OperatorSimplifyLocalOGC;
import com.datastax.shaded.esri.OperatorSymmetricDifferenceLocal;
import com.datastax.shaded.esri.OperatorTouchesLocal;
import com.datastax.shaded.esri.OperatorUnionLocal;
import com.datastax.shaded.esri.OperatorWithinLocal;
import com.datastax.shaded.esri.SpatialReference;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;

public class OperatorFactoryLocal
extends OperatorFactory {
    private static final OperatorFactoryLocal INSTANCE = new OperatorFactoryLocal();
    private static final HashMap<Operator.Type, Operator> st_supportedOperators = new HashMap();

    private OperatorFactoryLocal() {
    }

    public static OperatorFactoryLocal getInstance() {
        return INSTANCE;
    }

    @Override
    public Operator getOperator(Operator.Type type) {
        if (st_supportedOperators.containsKey((Object)type)) {
            return st_supportedOperators.get((Object)type);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isOperatorSupported(Operator.Type type) {
        return st_supportedOperators.containsKey((Object)type);
    }

    public static void saveJSONToTextFileDbg(String file_name, Geometry geometry, SpatialReference spatial_ref) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        OperatorFactoryLocal engine = OperatorFactoryLocal.getInstance();
        OperatorExportToJson exporterJSON = (OperatorExportToJson)engine.getOperator(Operator.Type.ExportToJson);
        String jsonString = exporterJSON.execute(spatial_ref, geometry);
        try {
            FileOutputStream outfile = new FileOutputStream(file_name);
            PrintStream p = new PrintStream(outfile);
            p.print(jsonString);
            p.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static MapGeometry loadGeometryFromJSONFileDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String jsonString = null;
        try {
            int read;
            FileInputStream stream = new FileInputStream(file_name);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            stream.close();
            jsonString = builder.toString();
        }
        catch (Exception ex) {
            // empty catch block
        }
        JsonFactory jf = new JsonFactory();
        JsonParser jp = null;
        try {
            jp = jf.createJsonParser(jsonString);
            jp.nextToken();
        }
        catch (Exception ex) {
            // empty catch block
        }
        MapGeometry mapGeom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, jp);
        return mapGeom;
    }

    public static Geometry loadGeometryFromEsriShapeDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        try {
            FileInputStream stream = new FileInputStream(file_name);
            FileChannel fchan = stream.getChannel();
            ByteBuffer bb = ByteBuffer.allocate((int)fchan.size());
            fchan.read(bb);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            Geometry g = OperatorImportFromESRIShape.local().execute(0, Geometry.Type.Unknown, bb);
            fchan.close();
            stream.close();
            return g;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    public static void saveGeometryToEsriShapeDbg(String file_name, Geometry geometry) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        try {
            ByteBuffer bb = OperatorExportToESRIShape.local().execute(0, geometry);
            FileOutputStream outfile = new FileOutputStream(file_name);
            FileChannel fchan = outfile.getChannel();
            fchan.write(bb);
            fchan.close();
            outfile.close();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    public static void saveToWKTFileDbg(String file_name, Geometry geometry, SpatialReference spatial_ref) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String jsonString = OperatorExportToWkt.local().execute(0, geometry, null);
        try {
            FileOutputStream outfile = new FileOutputStream(file_name);
            PrintStream p = new PrintStream(outfile);
            p.print(jsonString);
            p.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public static Geometry loadGeometryFromWKTFileDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String s = null;
        try {
            int read;
            FileInputStream stream = new FileInputStream(file_name);
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = ((Reader)reader).read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            stream.close();
            s = builder.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return OperatorImportFromWkt.local().execute(0, Geometry.Type.Unknown, s, null);
    }

    static {
        st_supportedOperators.put(Operator.Type.Project, new OperatorProjectLocal());
        st_supportedOperators.put(Operator.Type.ExportToJson, new OperatorExportToJsonLocal());
        st_supportedOperators.put(Operator.Type.ImportFromJson, new OperatorImportFromJsonLocal());
        st_supportedOperators.put(Operator.Type.ImportMapGeometryFromJson, new OperatorImportFromJsonLocal());
        st_supportedOperators.put(Operator.Type.ExportToESRIShape, new OperatorExportToESRIShapeLocal());
        st_supportedOperators.put(Operator.Type.ImportFromESRIShape, new OperatorImportFromESRIShapeLocal());
        st_supportedOperators.put(Operator.Type.Proximity2D, new OperatorProximity2DLocal());
        st_supportedOperators.put(Operator.Type.DensifyByLength, new OperatorDensifyByLengthLocal());
        st_supportedOperators.put(Operator.Type.Relate, new OperatorRelateLocal());
        st_supportedOperators.put(Operator.Type.Equals, new OperatorEqualsLocal());
        st_supportedOperators.put(Operator.Type.Disjoint, new OperatorDisjointLocal());
        st_supportedOperators.put(Operator.Type.Intersects, new OperatorIntersectsLocal());
        st_supportedOperators.put(Operator.Type.Within, new OperatorWithinLocal());
        st_supportedOperators.put(Operator.Type.Contains, new OperatorContainsLocal());
        st_supportedOperators.put(Operator.Type.Crosses, new OperatorCrossesLocal());
        st_supportedOperators.put(Operator.Type.Touches, new OperatorTouchesLocal());
        st_supportedOperators.put(Operator.Type.Overlaps, new OperatorOverlapsLocal());
        st_supportedOperators.put(Operator.Type.SimplifyOGC, new OperatorSimplifyLocalOGC());
        st_supportedOperators.put(Operator.Type.Simplify, new OperatorSimplifyLocal());
        st_supportedOperators.put(Operator.Type.Offset, new OperatorOffsetLocal());
        st_supportedOperators.put(Operator.Type.GeodeticDensifyByLength, new OperatorGeodeticDensifyLocal());
        st_supportedOperators.put(Operator.Type.ShapePreservingDensify, new OperatorShapePreservingDensifyLocal());
        st_supportedOperators.put(Operator.Type.GeodesicBuffer, new OperatorGeodesicBufferLocal());
        st_supportedOperators.put(Operator.Type.GeodeticLength, new OperatorGeodeticLengthLocal());
        st_supportedOperators.put(Operator.Type.GeodeticArea, new OperatorGeodeticAreaLocal());
        st_supportedOperators.put(Operator.Type.Buffer, new OperatorBufferLocal());
        st_supportedOperators.put(Operator.Type.Distance, new OperatorDistanceLocal());
        st_supportedOperators.put(Operator.Type.Intersection, new OperatorIntersectionLocal());
        st_supportedOperators.put(Operator.Type.Difference, new OperatorDifferenceLocal());
        st_supportedOperators.put(Operator.Type.SymmetricDifference, new OperatorSymmetricDifferenceLocal());
        st_supportedOperators.put(Operator.Type.Clip, new OperatorClipLocal());
        st_supportedOperators.put(Operator.Type.Cut, new OperatorCutLocal());
        st_supportedOperators.put(Operator.Type.ExportToWkb, new OperatorExportToWkbLocal());
        st_supportedOperators.put(Operator.Type.ImportFromWkb, new OperatorImportFromWkbLocal());
        st_supportedOperators.put(Operator.Type.ExportToWkt, new OperatorExportToWktLocal());
        st_supportedOperators.put(Operator.Type.ImportFromWkt, new OperatorImportFromWktLocal());
        st_supportedOperators.put(Operator.Type.ImportFromGeoJson, new OperatorImportFromGeoJsonLocal());
        st_supportedOperators.put(Operator.Type.ExportToGeoJson, new OperatorExportToGeoJsonLocal());
        st_supportedOperators.put(Operator.Type.Union, new OperatorUnionLocal());
        st_supportedOperators.put(Operator.Type.Generalize, new OperatorGeneralizeLocal());
        st_supportedOperators.put(Operator.Type.ConvexHull, new OperatorConvexHullLocal());
        st_supportedOperators.put(Operator.Type.Boundary, new OperatorBoundaryLocal());
    }
}

