/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.ByteBufferCursor;
import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryCursor;
import com.datastax.shaded.esri.OperatorExportToESRIShape;
import com.datastax.shaded.esri.OperatorExportToESRIShapeCursor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class OperatorExportToESRIShapeLocal
extends OperatorExportToESRIShape {
    OperatorExportToESRIShapeLocal() {
    }

    @Override
    ByteBufferCursor execute(int exportFlags, GeometryCursor geometryCursor) {
        return new OperatorExportToESRIShapeCursor(exportFlags, geometryCursor);
    }

    @Override
    public ByteBuffer execute(int exportFlags, Geometry geometry) {
        ByteBuffer shapeBuffer = null;
        int size = OperatorExportToESRIShapeCursor.exportToESRIShape(exportFlags, geometry, shapeBuffer);
        shapeBuffer = ByteBuffer.allocate(size).order(ByteOrder.LITTLE_ENDIAN);
        OperatorExportToESRIShapeCursor.exportToESRIShape(exportFlags, geometry, shapeBuffer);
        return shapeBuffer;
    }

    @Override
    public int execute(int exportFlags, Geometry geometry, ByteBuffer shapeBuffer) {
        shapeBuffer.order(ByteOrder.LITTLE_ENDIAN);
        return OperatorExportToESRIShapeCursor.exportToESRIShape(exportFlags, geometry, shapeBuffer);
    }
}

