/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.shaded.esri;

import com.datastax.shaded.esri.ConvexHull;
import com.datastax.shaded.esri.Geometry;
import com.datastax.shaded.esri.GeometryCursor;
import com.datastax.shaded.esri.GeometryException;
import com.datastax.shaded.esri.MultiPath;
import com.datastax.shaded.esri.MultiPoint;
import com.datastax.shaded.esri.MultiVertexGeometry;
import com.datastax.shaded.esri.Point;
import com.datastax.shaded.esri.Polygon;
import com.datastax.shaded.esri.Polyline;
import com.datastax.shaded.esri.ProgressTracker;
import com.datastax.shaded.esri.Segment;

class OperatorConvexHullCursor
extends GeometryCursor {
    private ProgressTracker m_progress_tracker;
    private boolean m_b_merge;
    private boolean m_b_done;
    private GeometryCursor m_inputGeometryCursor;
    private int m_index = -1;
    ConvexHull m_hull = new ConvexHull();

    OperatorConvexHullCursor(boolean b_merge, GeometryCursor geoms, ProgressTracker progress_tracker) {
        if (geoms == null) {
            throw new IllegalArgumentException();
        }
        this.m_b_merge = b_merge;
        this.m_b_done = false;
        this.m_inputGeometryCursor = geoms;
        this.m_progress_tracker = progress_tracker;
    }

    @Override
    public Geometry next() {
        if (this.m_b_merge) {
            if (!this.m_b_done) {
                Geometry result = this.calculateConvexHullMerging_(this.m_inputGeometryCursor, this.m_progress_tracker);
                this.m_b_done = true;
                return result;
            }
            return null;
        }
        if (!this.m_b_done) {
            Geometry geometry = this.m_inputGeometryCursor.next();
            if (geometry != null) {
                this.m_index = this.m_inputGeometryCursor.getGeometryID();
                return OperatorConvexHullCursor.calculateConvexHull_(geometry, this.m_progress_tracker);
            }
            this.m_b_done = true;
        }
        return null;
    }

    @Override
    public int getGeometryID() {
        return this.m_index;
    }

    private Geometry calculateConvexHullMerging_(GeometryCursor geoms, ProgressTracker progress_tracker) {
        Geometry geometry;
        while ((geometry = geoms.next()) != null) {
            this.m_hull.addGeometry(geometry);
        }
        return this.m_hull.getBoundingGeometry();
    }

    @Override
    public boolean tock() {
        if (this.m_b_done) {
            return true;
        }
        if (!this.m_b_merge) {
            throw new GeometryException("Invalid call for non merging convex hull.");
        }
        Geometry geometry = this.m_inputGeometryCursor.next();
        if (geometry != null) {
            this.m_hull.addGeometry(geometry);
            return true;
        }
        throw new GeometryException("Expects a non-null geometry.");
    }

    static Geometry calculateConvexHull_(Geometry geom, ProgressTracker progress_tracker) {
        MultiPoint multi_point;
        if (OperatorConvexHullCursor.isConvex_(geom, progress_tracker)) {
            return geom;
        }
        int type = geom.getType().value();
        if (MultiPath.isSegment(type)) {
            Polyline polyline = new Polyline(geom.getDescription());
            polyline.addSegment((Segment)geom, true);
            return polyline;
        }
        if (type == 550 && (multi_point = (MultiPoint)geom).getPointCount() == 2) {
            Point pt = new Point();
            Polyline polyline = new Polyline(geom.getDescription());
            multi_point.getPointByVal(0, pt);
            polyline.startPath(pt);
            multi_point.getPointByVal(1, pt);
            polyline.lineTo(pt);
            return polyline;
        }
        Polygon convex_hull = ConvexHull.construct((MultiVertexGeometry)geom);
        return convex_hull;
    }

    static boolean isConvex_(Geometry geom, ProgressTracker progress_tracker) {
        if (geom.isEmpty()) {
            return true;
        }
        int type = geom.getType().value();
        if (type == 33) {
            return true;
        }
        if (type == 197) {
            return true;
        }
        if (MultiPath.isSegment(type)) {
            return false;
        }
        if (type == 550) {
            MultiPoint multi_point = (MultiPoint)geom;
            return multi_point.getPointCount() == 1;
        }
        if (type == 1607) {
            Polyline polyline = (Polyline)geom;
            return polyline.getPathCount() == 1 && polyline.getPointCount() <= 2;
        }
        Polygon polygon = (Polygon)geom;
        if (polygon.getPathCount() != 1) {
            return false;
        }
        if (polygon.getPointCount() <= 2) {
            return true;
        }
        return ConvexHull.isPathConvex(polygon, 0, progress_tracker);
    }
}

