/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.shaded.jackson.annotation.JsonTypeInfo;
import com.datastax.shaded.jackson.databind.DatabindContext;
import com.datastax.shaded.jackson.databind.JavaType;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.datastax.shaded.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

class GraphSONTypeIdResolver
extends TypeIdResolverBase {
    private final Map<String, JavaType> idToType = new HashMap<String, JavaType>();
    private final Map<Class<?>, String> typeToId = new HashMap();

    GraphSONTypeIdResolver() {
    }

    public GraphSONTypeIdResolver addCustomType(String name, Class<?> clasz, ObjectMapper objectMapper) {
        this.getIdToType().put(name, objectMapper.getTypeFactory().constructType(clasz));
        this.getTypeToId().put(clasz, name);
        return this;
    }

    @Override
    public String idFromValue(Object o) {
        return this.idFromValueAndType(o, o.getClass());
    }

    @Override
    public String idFromValueAndType(Object o, Class<?> aClass) {
        if (!this.getTypeToId().containsKey(aClass)) {
            throw new IllegalArgumentException(String.format("Could not find a type identifier for the class : %s. Make sure the value to serialize has a type identifier registered for its class.", aClass));
        }
        return this.getTypeToId().get(aClass);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String s) {
        return this.getIdToType().containsKey(s) ? this.getIdToType().get(s) : databindContext.constructType((Type)((Object)String.class));
    }

    @Override
    public String getDescForKnownTypeIds() {
        return "GraphSONType";
    }

    @Override
    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }

    private Map<String, JavaType> getIdToType() {
        return this.idToType;
    }

    private Map<Class<?>, String> getTypeToId() {
        return this.typeToId;
    }
}

