/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse;

import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.dse.DseLoadBalancingPolicy;
import com.datastax.driver.dse.graph.GraphOptions;
import java.util.UUID;

public class DseConfiguration
extends Configuration {
    private final GraphOptions graphOptions;
    private final String applicationName;
    private final String applicationVersion;
    private final UUID clusterId;

    DseConfiguration(Configuration toCopy, GraphOptions graphOptions, String applicationName, String applicationVersion, UUID clusterId) {
        super(toCopy);
        this.graphOptions = graphOptions;
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
        this.clusterId = clusterId;
    }

    public GraphOptions getGraphOptions() {
        return this.graphOptions;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public UUID getClusterId() {
        return this.clusterId;
    }

    public static LoadBalancingPolicy defaultLoadBalancingPolicy() {
        return new DseLoadBalancingPolicy(Policies.defaultLoadBalancingPolicy());
    }
}

