/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse;

import com.datastax.driver.core.AbstractSession;
import com.datastax.driver.core.AsyncContinuousPagingResult;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ContinuousPagingOptions;
import com.datastax.driver.core.ContinuousPagingResult;
import com.datastax.driver.core.ContinuousPagingSession;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.AddressTranslator;
import com.datastax.driver.dse.DriverThrowables;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.HostTargetingStatement;
import com.datastax.driver.dse.graph.GraphOptions;
import com.datastax.driver.dse.graph.GraphResultSet;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultDseSession
extends AbstractSession
implements DseSession,
ContinuousPagingSession {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDseSession.class);
    private static final String ANALYTICS_GRAPH_SOURCE = "a";
    private static final Statement LOOKUP_ANALYTICS_GRAPH_SERVER = new SimpleStatement("CALL DseClientTool.getAnalyticsGraphServer()");
    private final Session delegate;
    private final DseCluster dseCluster;

    DefaultDseSession(Session delegate, DseCluster dseCluster) {
        this.delegate = delegate;
        this.dseCluster = dseCluster;
    }

    @Override
    public DseSession init() {
        try {
            return (DseSession)Uninterruptibles.getUninterruptibly(this.initAsync());
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ListenableFuture<Session> initAsync() {
        return GuavaCompatibility.INSTANCE.transform(this.delegate.initAsync(), new Function<Session, Session>(){

            public Session apply(Session input) {
                return DefaultDseSession.this;
            }
        });
    }

    @Override
    public GraphResultSet executeGraph(String query) {
        return this.executeGraph(new SimpleGraphStatement(query));
    }

    @Override
    public GraphResultSet executeGraph(String query, Map<String, Object> values) {
        return this.executeGraph(new SimpleGraphStatement(query, values));
    }

    @Override
    public GraphResultSet executeGraph(GraphStatement statement) {
        try {
            return (GraphResultSet)Uninterruptibles.getUninterruptibly(this.executeGraphAsync(statement));
        }
        catch (ExecutionException e) {
            throw DriverThrowables.propagateCause(e);
        }
    }

    @Override
    public ListenableFuture<GraphResultSet> executeGraphAsync(String query) {
        return this.executeGraphAsync(new SimpleGraphStatement(query));
    }

    @Override
    public ListenableFuture<GraphResultSet> executeGraphAsync(String query, Map<String, Object> values) {
        return this.executeGraphAsync(new SimpleGraphStatement(query, values));
    }

    @Override
    public ListenableFuture<GraphResultSet> executeGraphAsync(final GraphStatement graphStatement) {
        final Statement statement = DefaultDseSession.generateCoreStatement(this.dseCluster.getConfiguration().getGraphOptions(), graphStatement);
        if (ANALYTICS_GRAPH_SOURCE.equals(graphStatement.getGraphSource())) {
            ListenableFuture<ResultSet> serverLocation = GuavaCompatibility.INSTANCE.withFallback(this.delegate.executeAsync(LOOKUP_ANALYTICS_GRAPH_SERVER), new AsyncFunction<Throwable, ResultSet>(){

                public ListenableFuture<ResultSet> apply(Throwable t) throws Exception {
                    logger.debug("Error querying graph analytics server, query will not be routed optimally", t);
                    return null;
                }
            });
            return GuavaCompatibility.INSTANCE.transformAsync(serverLocation, new AsyncFunction<ResultSet, GraphResultSet>(){

                public ListenableFuture<GraphResultSet> apply(ResultSet rs) throws Exception {
                    Host analyticsServer = rs == null ? null : DefaultDseSession.this.extractHostFromAnalyticsServerQuery(rs);
                    Statement targetedStatement = analyticsServer == null ? statement : new HostTargetingStatement(statement, analyticsServer);
                    return GuavaCompatibility.INSTANCE.transform(DefaultDseSession.this.delegate.executeAsync(targetedStatement), new Function<ResultSet, GraphResultSet>(){

                        public GraphResultSet apply(ResultSet input) {
                            return new GraphResultSet(input, graphStatement.getTransformResultFunction());
                        }
                    });
                }
            });
        }
        return GuavaCompatibility.INSTANCE.transform(this.delegate.executeAsync(statement), new Function<ResultSet, GraphResultSet>(){

            public GraphResultSet apply(ResultSet input) {
                return new GraphResultSet(input, graphStatement.getTransformResultFunction());
            }
        });
    }

    private Host extractHostFromAnalyticsServerQuery(ResultSet rs) {
        if (rs.isExhausted()) {
            logger.debug("Empty response querying graph analytics server, query will not be routed optimally");
            return null;
        }
        try {
            Map<String, String> result = rs.one().getMap("result", String.class, String.class);
            if (result != null && result.containsKey("location")) {
                String location = result.get("location");
                String hostName = location.substring(0, location.lastIndexOf(":"));
                AddressTranslator addressTranslator = this.dseCluster.getConfiguration().getPolicies().getAddressTranslator();
                int port = this.dseCluster.getConfiguration().getProtocolOptions().getPort();
                InetSocketAddress broadcastRpcAddress = addressTranslator.translate(new InetSocketAddress(hostName, port));
                for (Host host : this.dseCluster.getMetadata().getAllHosts()) {
                    if (!host.getSocketAddress().equals(broadcastRpcAddress)) continue;
                    logger.debug("Routing analytics query to {}", (Object)host);
                    return host;
                }
                logger.debug("Could not find host matching graph analytics server {}, query will not be routed optimally", (Object)broadcastRpcAddress);
                return null;
            }
            logger.debug("Could not extract graph analytics server location from '{}', query will not be routed optimally", result);
            return null;
        }
        catch (Exception e) {
            logger.debug("Error while processing graph analytics server location, query will not be routed optimally", (Throwable)e);
            return null;
        }
    }

    @VisibleForTesting
    static Statement generateCoreStatement(GraphOptions graphOptions, GraphStatement graphStatement) {
        Boolean idempotent;
        Statement statement = graphStatement.unwrap(graphOptions);
        statement.setOutgoingPayload(graphOptions.buildPayloadWithDefaults(graphStatement));
        if (statement.getReadTimeoutMillis() == Integer.MIN_VALUE) {
            statement.setReadTimeoutMillis(graphOptions.getReadTimeoutMillis());
        }
        if ((idempotent = graphStatement.isIdempotent()) != null) {
            statement.setIdempotent(idempotent);
        }
        return statement;
    }

    @Override
    public DseCluster getCluster() {
        return this.dseCluster;
    }

    @Override
    public String getLoggedKeyspace() {
        return this.delegate.getLoggedKeyspace();
    }

    @Override
    public CloseFuture closeAsync() {
        return this.delegate.closeAsync();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public Session.State getState() {
        return this.delegate.getState();
    }

    @Override
    public ResultSetFuture executeAsync(Statement statement) {
        return this.delegate.executeAsync(statement);
    }

    @Override
    public ResultSet execute(String query) {
        return this.delegate.execute(query);
    }

    @Override
    public ResultSet execute(String query, Object ... values) {
        return this.delegate.execute(query, values);
    }

    @Override
    public ResultSet execute(String query, Map<String, Object> values) {
        return this.delegate.execute(query, values);
    }

    @Override
    public ResultSet execute(Statement statement) {
        return this.delegate.execute(statement);
    }

    @Override
    public ResultSetFuture executeAsync(String query) {
        return this.delegate.executeAsync(query);
    }

    @Override
    public ResultSetFuture executeAsync(String query, Object ... values) {
        return this.delegate.executeAsync(query, values);
    }

    @Override
    public ResultSetFuture executeAsync(String query, Map<String, Object> values) {
        return this.delegate.executeAsync(query, values);
    }

    @Override
    public ListenableFuture<AsyncContinuousPagingResult> executeContinuouslyAsync(Statement statement, ContinuousPagingOptions options) {
        return ((ContinuousPagingSession)this.delegate).executeContinuouslyAsync(statement, options);
    }

    @Override
    public ContinuousPagingResult executeContinuously(Statement statement, ContinuousPagingOptions options) {
        return ((ContinuousPagingSession)this.delegate).executeContinuously(statement, options);
    }

    @Override
    public PreparedStatement prepare(String query) {
        return this.delegate.prepare(query);
    }

    @Override
    public PreparedStatement prepare(RegularStatement statement) {
        return this.delegate.prepare(statement);
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(String query) {
        return this.delegate.prepareAsync(query);
    }

    @Override
    public ListenableFuture<PreparedStatement> prepareAsync(RegularStatement statement) {
        return this.delegate.prepareAsync(statement);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    protected ListenableFuture<PreparedStatement> prepareAsync(String query, String keyspace, Map<String, ByteBuffer> customPayload) {
        throw new IllegalStateException("This method should never be called on DefaultDseSession");
    }

    @Override
    protected Cluster getConcreteCluster() {
        return this.dseCluster.delegate();
    }
}

