/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.CBUtil;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ContinuousPagingOptions;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.Message;
import com.datastax.driver.core.ProtocolEvent;
import com.datastax.driver.core.ProtocolFeature;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;

class Requests {
    private Requests() {
    }

    static class ReviseRequest
    extends Message.Request {
        static final Message.Coder<ReviseRequest> coder = new Message.Coder<ReviseRequest>(){

            @Override
            public void encode(ReviseRequest msg, ByteBuf dest, ProtocolVersion version) {
                dest.writeInt(msg.revisionType.id);
                dest.writeInt(msg.id);
                if (version.compareTo(ProtocolVersion.DSE_V2) >= 0 && msg.revisionType.id == RevisionType.CONTINUOUS_PAGING_BACKPRESSURE.id) {
                    dest.writeInt(msg.nextPages);
                }
            }

            @Override
            public int encodedSize(ReviseRequest msg, ProtocolVersion version) {
                int ret = 8;
                if (version.compareTo(ProtocolVersion.DSE_V2) >= 0 && msg.revisionType.id == RevisionType.CONTINUOUS_PAGING_BACKPRESSURE.id) {
                    ret += 4;
                }
                return ret;
            }
        };
        private final RevisionType revisionType;
        private final int id;
        private final int nextPages;

        ReviseRequest(RevisionType revisionType, int id, int nextPages) {
            super(Message.Request.Type.REVISE_REQUEST);
            this.revisionType = revisionType;
            this.id = id;
            this.nextPages = nextPages;
            if (id == RevisionType.CONTINUOUS_PAGING_BACKPRESSURE.id && nextPages <= 0) {
                throw new IllegalArgumentException("nextPages should be >= 0 for update of type CONTINUOUS_PAGING_BACKPRESSURE");
            }
        }

        @Override
        protected Message.Request copyInternal() {
            return new ReviseRequest(this.revisionType, this.id, this.nextPages);
        }

        static ReviseRequest continuousPagingCancel(int id) {
            return new ReviseRequest(RevisionType.CONTINUOUS_PAGING_CANCEL, id, 0);
        }

        static ReviseRequest continuousPagingBackpressure(int id, int nextPages) {
            return new ReviseRequest(RevisionType.CONTINUOUS_PAGING_BACKPRESSURE, id, nextPages);
        }

        static enum RevisionType {
            CONTINUOUS_PAGING_CANCEL(1),
            CONTINUOUS_PAGING_BACKPRESSURE(2);

            private final int id;

            private RevisionType(int id) {
                this.id = id;
            }
        }
    }

    static class AuthResponse
    extends Message.Request {
        static final Message.Coder<AuthResponse> coder = new Message.Coder<AuthResponse>(){

            @Override
            public void encode(AuthResponse response, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeValue(response.token, dest);
            }

            @Override
            public int encodedSize(AuthResponse response, ProtocolVersion version) {
                return CBUtil.sizeOfValue(response.token);
            }
        };
        private final byte[] token;

        AuthResponse(byte[] token) {
            super(Message.Request.Type.AUTH_RESPONSE);
            this.token = token;
        }

        @Override
        protected Message.Request copyInternal() {
            return new AuthResponse(this.token);
        }
    }

    static class Register
    extends Message.Request {
        static final Message.Coder<Register> coder = new Message.Coder<Register>(){

            @Override
            public void encode(Register msg, ByteBuf dest, ProtocolVersion version) {
                dest.writeShort(msg.eventTypes.size());
                for (ProtocolEvent.Type type : msg.eventTypes) {
                    CBUtil.writeEnumValue(type, dest);
                }
            }

            @Override
            public int encodedSize(Register msg, ProtocolVersion version) {
                int size = 2;
                for (ProtocolEvent.Type type : msg.eventTypes) {
                    size += CBUtil.sizeOfEnumValue(type);
                }
                return size;
            }
        };
        private final List<ProtocolEvent.Type> eventTypes;

        Register(List<ProtocolEvent.Type> eventTypes) {
            super(Message.Request.Type.REGISTER);
            this.eventTypes = eventTypes;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Register(this.eventTypes);
        }

        public String toString() {
            return "REGISTER " + this.eventTypes;
        }
    }

    static class Prepare
    extends Message.Request {
        static final Message.Coder<Prepare> coder = new Message.Coder<Prepare>(){

            @Override
            public void encode(Prepare msg, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeLongString(msg.query, dest);
                if (ProtocolFeature.KEYSPACE_ON_QUERY.isSupportedBy(version)) {
                    if (msg.keyspace != null) {
                        dest.writeInt(1);
                        CBUtil.writeString(msg.keyspace, dest);
                    } else {
                        dest.writeInt(0);
                    }
                }
            }

            @Override
            public int encodedSize(Prepare msg, ProtocolVersion version) {
                int size = CBUtil.sizeOfLongString(msg.query);
                if (ProtocolFeature.KEYSPACE_ON_QUERY.isSupportedBy(version)) {
                    size += 4;
                    if (msg.keyspace != null) {
                        size += CBUtil.sizeOfString(msg.keyspace);
                    }
                }
                return size;
            }
        };
        private final String query;
        private final String keyspace;

        Prepare(String query, String keyspace) {
            super(Message.Request.Type.PREPARE);
            this.query = query;
            this.keyspace = keyspace;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Prepare(this.query, this.keyspace);
        }

        public String toString() {
            return "PREPARE " + this.query;
        }
    }

    static class BatchProtocolOptions {
        private final EnumSet<QueryFlag> flags = EnumSet.noneOf(QueryFlag.class);
        final ConsistencyLevel consistency;
        final ConsistencyLevel serialConsistency;
        final long defaultTimestamp;
        final String keyspace;

        BatchProtocolOptions(ConsistencyLevel consistency, ConsistencyLevel serialConsistency, long defaultTimestamp, String keyspace) {
            this.consistency = consistency;
            this.serialConsistency = serialConsistency;
            this.defaultTimestamp = defaultTimestamp;
            this.keyspace = keyspace;
            if (serialConsistency != ConsistencyLevel.SERIAL) {
                this.flags.add(QueryFlag.SERIAL_CONSISTENCY);
            }
            if (defaultTimestamp != Long.MIN_VALUE) {
                this.flags.add(QueryFlag.DEFAULT_TIMESTAMP);
            }
            if (keyspace != null) {
                this.flags.add(QueryFlag.KEYSPACE);
            }
        }

        BatchProtocolOptions copy(ConsistencyLevel newConsistencyLevel) {
            return new BatchProtocolOptions(newConsistencyLevel, this.serialConsistency, this.defaultTimestamp, this.keyspace);
        }

        void encode(ByteBuf dest, ProtocolVersion version) {
            switch (version) {
                case V2: {
                    CBUtil.writeConsistencyLevel(this.consistency, dest);
                    break;
                }
                case V3: 
                case V4: 
                case V5: 
                case DSE_V1: 
                case DSE_V2: {
                    CBUtil.writeConsistencyLevel(this.consistency, dest);
                    QueryFlag.serialize(this.flags, dest, version);
                    if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
                        CBUtil.writeConsistencyLevel(this.serialConsistency, dest);
                    }
                    if (this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) {
                        dest.writeLong(this.defaultTimestamp);
                    }
                    if (!ProtocolFeature.KEYSPACE_ON_QUERY.isSupportedBy(version) || !this.flags.contains((Object)QueryFlag.KEYSPACE)) break;
                    CBUtil.writeString(this.keyspace, dest);
                    break;
                }
                default: {
                    throw version.unsupported();
                }
            }
        }

        int encodedSize(ProtocolVersion version) {
            switch (version) {
                case V2: {
                    return CBUtil.sizeOfConsistencyLevel(this.consistency);
                }
                case V3: 
                case V4: 
                case V5: 
                case DSE_V1: 
                case DSE_V2: {
                    int size = 0;
                    size += CBUtil.sizeOfConsistencyLevel(this.consistency);
                    size += QueryFlag.serializedSize(version);
                    if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
                        size += CBUtil.sizeOfConsistencyLevel(this.serialConsistency);
                    }
                    if (this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) {
                        size += 8;
                    }
                    if (ProtocolFeature.KEYSPACE_ON_QUERY.isSupportedBy(version) && this.flags.contains((Object)QueryFlag.KEYSPACE)) {
                        size += CBUtil.sizeOfString(this.keyspace);
                    }
                    return size;
                }
            }
            throw version.unsupported();
        }

        public String toString() {
            return String.format("[cl=%s, serialCl=%s, defaultTs=%d]", new Object[]{this.consistency, this.serialConsistency, this.defaultTimestamp});
        }
    }

    static class Batch
    extends Message.Request {
        static final Message.Coder<Batch> coder = new Message.Coder<Batch>(){

            @Override
            public void encode(Batch msg, ByteBuf dest, ProtocolVersion version) {
                int queries = msg.queryOrIdList.size();
                assert (queries <= 65535);
                dest.writeByte((int)this.fromType(msg.type));
                dest.writeShort(queries);
                for (int i = 0; i < queries; ++i) {
                    Object q = msg.queryOrIdList.get(i);
                    dest.writeByte((int)((byte)(!(q instanceof String) ? 1 : 0)));
                    if (q instanceof String) {
                        CBUtil.writeLongString((String)q, dest);
                    } else {
                        CBUtil.writeShortBytes(((MD5Digest)q).bytes, dest);
                    }
                    CBUtil.writeValueList(msg.values.get(i), dest);
                }
                msg.options.encode(dest, version);
            }

            @Override
            public int encodedSize(Batch msg, ProtocolVersion version) {
                int size = 3;
                for (int i = 0; i < msg.queryOrIdList.size(); ++i) {
                    Object q = msg.queryOrIdList.get(i);
                    size += 1 + (q instanceof String ? CBUtil.sizeOfLongString((String)q) : CBUtil.sizeOfShortBytes(((MD5Digest)q).bytes));
                    size += CBUtil.sizeOfValueList(msg.values.get(i));
                }
                return size += msg.options.encodedSize(version);
            }

            private byte fromType(BatchStatement.Type type) {
                switch (type) {
                    case LOGGED: {
                        return 0;
                    }
                    case UNLOGGED: {
                        return 1;
                    }
                    case COUNTER: {
                        return 2;
                    }
                }
                throw new AssertionError();
            }
        };
        final BatchStatement.Type type;
        final List<Object> queryOrIdList;
        final List<List<ByteBuffer>> values;
        final BatchProtocolOptions options;

        Batch(BatchStatement.Type type, List<Object> queryOrIdList, List<List<ByteBuffer>> values, BatchProtocolOptions options, boolean tracingRequested) {
            super(Message.Request.Type.BATCH, tracingRequested);
            this.type = type;
            this.queryOrIdList = queryOrIdList;
            this.values = values;
            this.options = options;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Batch(this.type, this.queryOrIdList, this.values, this.options, this.isTracingRequested());
        }

        @Override
        protected Message.Request copyInternal(ConsistencyLevel newConsistencyLevel) {
            return new Batch(this.type, this.queryOrIdList, this.values, this.options.copy(newConsistencyLevel), this.isTracingRequested());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("BATCH of [");
            for (int i = 0; i < this.queryOrIdList.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.queryOrIdList.get(i)).append(" with ").append(this.values.get(i).size()).append(" values");
            }
            sb.append("] with options ").append(this.options);
            return sb.toString();
        }
    }

    static class QueryProtocolOptions {
        static final QueryProtocolOptions DEFAULT = new QueryProtocolOptions(Message.Request.Type.QUERY, ConsistencyLevel.ONE, Collections.<ByteBuffer>emptyList(), Collections.<String, ByteBuffer>emptyMap(), false, -1, null, ConsistencyLevel.SERIAL, Long.MIN_VALUE, null, null);
        private final EnumSet<QueryFlag> flags = EnumSet.noneOf(QueryFlag.class);
        private final Message.Request.Type requestType;
        final ConsistencyLevel consistency;
        final List<ByteBuffer> positionalValues;
        final Map<String, ByteBuffer> namedValues;
        final boolean skipMetadata;
        final int pageSize;
        final ByteBuffer pagingState;
        final ConsistencyLevel serialConsistency;
        final long defaultTimestamp;
        final String keyspace;
        final ContinuousPagingOptions continuousPagingOptions;

        QueryProtocolOptions(Message.Request.Type requestType, ConsistencyLevel consistency, List<ByteBuffer> positionalValues, Map<String, ByteBuffer> namedValues, boolean skipMetadata, int pageSize, ByteBuffer pagingState, ConsistencyLevel serialConsistency, long defaultTimestamp, String keyspace, ContinuousPagingOptions continuousPagingOptions) {
            Preconditions.checkArgument((positionalValues.isEmpty() || namedValues.isEmpty() ? 1 : 0) != 0);
            this.requestType = requestType;
            this.consistency = consistency;
            this.positionalValues = positionalValues;
            this.namedValues = namedValues;
            this.skipMetadata = skipMetadata;
            this.pageSize = pageSize;
            this.pagingState = pagingState;
            this.serialConsistency = serialConsistency;
            this.defaultTimestamp = defaultTimestamp;
            this.keyspace = keyspace;
            this.continuousPagingOptions = continuousPagingOptions;
            if (!positionalValues.isEmpty()) {
                this.flags.add(QueryFlag.VALUES);
            }
            if (!namedValues.isEmpty()) {
                this.flags.add(QueryFlag.VALUES);
                this.flags.add(QueryFlag.VALUE_NAMES);
            }
            if (skipMetadata) {
                this.flags.add(QueryFlag.SKIP_METADATA);
            }
            if (pageSize >= 0) {
                this.flags.add(QueryFlag.PAGE_SIZE);
                if (continuousPagingOptions != null && continuousPagingOptions.getPageUnit() == ContinuousPagingOptions.PageUnit.BYTES) {
                    this.flags.add(QueryFlag.PAGE_SIZE_BYTES);
                }
            }
            if (pagingState != null) {
                this.flags.add(QueryFlag.PAGING_STATE);
            }
            if (serialConsistency != ConsistencyLevel.SERIAL) {
                this.flags.add(QueryFlag.SERIAL_CONSISTENCY);
            }
            if (defaultTimestamp != Long.MIN_VALUE) {
                this.flags.add(QueryFlag.DEFAULT_TIMESTAMP);
            }
            if (keyspace != null) {
                this.flags.add(QueryFlag.KEYSPACE);
            }
            if (continuousPagingOptions != null) {
                this.flags.add(QueryFlag.CONTINUOUS_PAGING);
            }
        }

        QueryProtocolOptions copy(ConsistencyLevel newConsistencyLevel) {
            return new QueryProtocolOptions(this.requestType, newConsistencyLevel, this.positionalValues, this.namedValues, this.skipMetadata, this.pageSize, this.pagingState, this.serialConsistency, this.defaultTimestamp, this.keyspace, this.continuousPagingOptions);
        }

        void encode(ByteBuf dest, ProtocolVersion version) {
            switch (version) {
                case V1: {
                    if (this.requestType == Message.Request.Type.EXECUTE) {
                        CBUtil.writeValueList(this.positionalValues, dest);
                    }
                    CBUtil.writeConsistencyLevel(this.consistency, dest);
                    break;
                }
                case V2: 
                case V3: 
                case V4: 
                case V5: 
                case DSE_V1: 
                case DSE_V2: {
                    CBUtil.writeConsistencyLevel(this.consistency, dest);
                    QueryFlag.serialize(this.flags, dest, version);
                    if (this.flags.contains((Object)QueryFlag.VALUES)) {
                        if (this.flags.contains((Object)QueryFlag.VALUE_NAMES)) {
                            assert (version.compareTo(ProtocolVersion.V3) >= 0);
                            CBUtil.writeNamedValueList(this.namedValues, dest);
                        } else {
                            CBUtil.writeValueList(this.positionalValues, dest);
                        }
                    }
                    if (this.flags.contains((Object)QueryFlag.PAGE_SIZE)) {
                        dest.writeInt(this.pageSize);
                    }
                    if (this.flags.contains((Object)QueryFlag.PAGING_STATE)) {
                        CBUtil.writeValue(this.pagingState, dest);
                    }
                    if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
                        CBUtil.writeConsistencyLevel(this.serialConsistency, dest);
                    }
                    if (version.compareTo(ProtocolVersion.V3) >= 0 && this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) {
                        dest.writeLong(this.defaultTimestamp);
                    }
                    if (ProtocolFeature.KEYSPACE_ON_QUERY.isSupportedBy(version) && this.flags.contains((Object)QueryFlag.KEYSPACE)) {
                        CBUtil.writeString(this.keyspace, dest);
                    }
                    if (version.compareTo(ProtocolVersion.DSE_V1) < 0 || !this.flags.contains((Object)QueryFlag.CONTINUOUS_PAGING)) break;
                    dest.writeInt(this.continuousPagingOptions.getMaxPages());
                    dest.writeInt(this.continuousPagingOptions.getMaxPagesPerSecond());
                    if (version.compareTo(ProtocolVersion.DSE_V2) < 0) break;
                    dest.writeInt(this.continuousPagingOptions.getMaxEnqueuedPages());
                    break;
                }
                default: {
                    throw version.unsupported();
                }
            }
        }

        int encodedSize(ProtocolVersion version) {
            switch (version) {
                case V1: {
                    return (this.requestType == Message.Request.Type.EXECUTE ? CBUtil.sizeOfValueList(this.positionalValues) : 0) + CBUtil.sizeOfConsistencyLevel(this.consistency);
                }
                case V2: 
                case V3: 
                case V4: 
                case V5: 
                case DSE_V1: 
                case DSE_V2: {
                    int size = 0;
                    size += CBUtil.sizeOfConsistencyLevel(this.consistency);
                    size += QueryFlag.serializedSize(version);
                    if (this.flags.contains((Object)QueryFlag.VALUES)) {
                        if (this.flags.contains((Object)QueryFlag.VALUE_NAMES)) {
                            assert (version.compareTo(ProtocolVersion.V3) >= 0);
                            size += CBUtil.sizeOfNamedValueList(this.namedValues);
                        } else {
                            size += CBUtil.sizeOfValueList(this.positionalValues);
                        }
                    }
                    if (this.flags.contains((Object)QueryFlag.PAGE_SIZE)) {
                        size += 4;
                    }
                    if (this.flags.contains((Object)QueryFlag.PAGING_STATE)) {
                        size += CBUtil.sizeOfValue(this.pagingState);
                    }
                    if (this.flags.contains((Object)QueryFlag.SERIAL_CONSISTENCY)) {
                        size += CBUtil.sizeOfConsistencyLevel(this.serialConsistency);
                    }
                    if (version.compareTo(ProtocolVersion.V3) >= 0 && this.flags.contains((Object)QueryFlag.DEFAULT_TIMESTAMP)) {
                        size += 8;
                    }
                    if (ProtocolFeature.KEYSPACE_ON_QUERY.isSupportedBy(version) && this.flags.contains((Object)QueryFlag.KEYSPACE)) {
                        size += CBUtil.sizeOfString(this.keyspace);
                    }
                    if (version.compareTo(ProtocolVersion.DSE_V1) >= 0 && this.flags.contains((Object)QueryFlag.CONTINUOUS_PAGING)) {
                        size += version.compareTo(ProtocolVersion.DSE_V2) >= 0 ? 12 : 8;
                    }
                    return size;
                }
            }
            throw version.unsupported();
        }

        public String toString() {
            return String.format("[cl=%s, positionalVals=%s, namedVals=%s, skip=%b, psize=%d, state=%s, serialCl=%s]", new Object[]{this.consistency, this.positionalValues, this.namedValues, this.skipMetadata, this.pageSize, this.pagingState, this.serialConsistency});
        }
    }

    static enum QueryFlag {
        VALUES(0),
        SKIP_METADATA(1),
        PAGE_SIZE(2),
        PAGING_STATE(3),
        SERIAL_CONSISTENCY(4),
        DEFAULT_TIMESTAMP(5),
        VALUE_NAMES(6),
        KEYSPACE(7),
        PAGE_SIZE_BYTES(30),
        CONTINUOUS_PAGING(31);

        private final int pos;

        private QueryFlag(int pos) {
            this.pos = pos;
        }

        static EnumSet<QueryFlag> deserialize(int flags) {
            EnumSet<QueryFlag> set = EnumSet.noneOf(QueryFlag.class);
            QueryFlag[] values = QueryFlag.values();
            for (int n = 0; n < values.length; ++n) {
                if ((flags & 1 << n) == 0) continue;
                set.add(values[n]);
            }
            return set;
        }

        static void serialize(EnumSet<QueryFlag> flags, ByteBuf dest, ProtocolVersion version) {
            int i = 0;
            boolean isV5 = version.compareTo(ProtocolVersion.V5) >= 0;
            for (QueryFlag flag : flags) {
                if (flag.pos >= QueryFlag.KEYSPACE.pos && !isV5 || flag == KEYSPACE && !ProtocolFeature.KEYSPACE_ON_QUERY.isSupportedBy(version)) continue;
                i |= 1 << flag.pos;
            }
            if (isV5) {
                dest.writeInt(i);
            } else {
                dest.writeByte((int)((byte)i));
            }
        }

        static int serializedSize(ProtocolVersion version) {
            return version.compareTo(ProtocolVersion.V5) >= 0 ? 4 : 1;
        }
    }

    static class Execute
    extends Message.Request {
        static final Message.Coder<Execute> coder = new Message.Coder<Execute>(){

            @Override
            public void encode(Execute msg, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeShortBytes(msg.statementId.bytes, dest);
                if (ProtocolFeature.PREPARED_METADATA_CHANGES.isSupportedBy(version)) {
                    CBUtil.writeShortBytes(msg.resultMetadataId.bytes, dest);
                }
                msg.options.encode(dest, version);
            }

            @Override
            public int encodedSize(Execute msg, ProtocolVersion version) {
                int size = CBUtil.sizeOfShortBytes(msg.statementId.bytes);
                if (ProtocolFeature.PREPARED_METADATA_CHANGES.isSupportedBy(version)) {
                    size += CBUtil.sizeOfShortBytes(msg.resultMetadataId.bytes);
                }
                return size += msg.options.encodedSize(version);
            }
        };
        final MD5Digest statementId;
        final MD5Digest resultMetadataId;
        final QueryProtocolOptions options;

        Execute(MD5Digest statementId, MD5Digest resultMetadataId, QueryProtocolOptions options, boolean tracingRequested) {
            super(Message.Request.Type.EXECUTE, tracingRequested);
            this.statementId = statementId;
            this.resultMetadataId = resultMetadataId;
            this.options = options;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Execute(this.statementId, this.resultMetadataId, this.options, this.isTracingRequested());
        }

        @Override
        protected Message.Request copyInternal(ConsistencyLevel newConsistencyLevel) {
            return new Execute(this.statementId, this.resultMetadataId, this.options.copy(newConsistencyLevel), this.isTracingRequested());
        }

        public String toString() {
            if (this.resultMetadataId != null) {
                return "EXECUTE preparedId: " + this.statementId + " resultMetadataId: " + this.resultMetadataId + " (" + this.options + ')';
            }
            return "EXECUTE preparedId: " + this.statementId + " (" + this.options + ')';
        }
    }

    static class Query
    extends Message.Request {
        static final Message.Coder<Query> coder = new Message.Coder<Query>(){

            @Override
            public void encode(Query msg, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeLongString(msg.query, dest);
                msg.options.encode(dest, version);
            }

            @Override
            public int encodedSize(Query msg, ProtocolVersion version) {
                return CBUtil.sizeOfLongString(msg.query) + msg.options.encodedSize(version);
            }
        };
        final String query;
        final QueryProtocolOptions options;

        Query(String query) {
            this(query, QueryProtocolOptions.DEFAULT, false);
        }

        Query(String query, QueryProtocolOptions options, boolean tracingRequested) {
            super(Message.Request.Type.QUERY, tracingRequested);
            this.query = query;
            this.options = options;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Query(this.query, this.options, this.isTracingRequested());
        }

        @Override
        protected Message.Request copyInternal(ConsistencyLevel newConsistencyLevel) {
            return new Query(this.query, this.options.copy(newConsistencyLevel), this.isTracingRequested());
        }

        public String toString() {
            return "QUERY " + this.query + '(' + this.options + ')';
        }
    }

    static class Options
    extends Message.Request {
        static final Message.Coder<Options> coder = new Message.Coder<Options>(){

            @Override
            public void encode(Options msg, ByteBuf dest, ProtocolVersion version) {
            }

            @Override
            public int encodedSize(Options msg, ProtocolVersion version) {
                return 0;
            }
        };

        Options() {
            super(Message.Request.Type.OPTIONS);
        }

        @Override
        protected Message.Request copyInternal() {
            return new Options();
        }

        public String toString() {
            return "OPTIONS";
        }
    }

    static class Credentials
    extends Message.Request {
        static final Message.Coder<Credentials> coder = new Message.Coder<Credentials>(){

            @Override
            public void encode(Credentials msg, ByteBuf dest, ProtocolVersion version) {
                assert (version == ProtocolVersion.V1);
                CBUtil.writeStringMap(msg.credentials, dest);
            }

            @Override
            public int encodedSize(Credentials msg, ProtocolVersion version) {
                assert (version == ProtocolVersion.V1);
                return CBUtil.sizeOfStringMap(msg.credentials);
            }
        };
        private final Map<String, String> credentials;

        Credentials(Map<String, String> credentials) {
            super(Message.Request.Type.CREDENTIALS);
            this.credentials = credentials;
        }

        @Override
        protected Message.Request copyInternal() {
            return new Credentials(this.credentials);
        }
    }

    static class Startup
    extends Message.Request {
        private static final String CQL_VERSION_OPTION = "CQL_VERSION";
        private static final String CQL_VERSION = "3.0.0";
        private static final String DRIVER_VERSION_OPTION = "DRIVER_VERSION";
        private static final String DRIVER_NAME_OPTION = "DRIVER_NAME";
        private static final String DRIVER_NAME = "DataStax Enterprise Java Driver";
        static final String COMPRESSION_OPTION = "COMPRESSION";
        static final String NO_COMPACT_OPTION = "NO_COMPACT";
        static final Message.Coder<Startup> coder = new Message.Coder<Startup>(){

            @Override
            public void encode(Startup msg, ByteBuf dest, ProtocolVersion version) {
                CBUtil.writeStringMap(msg.options, dest);
            }

            @Override
            public int encodedSize(Startup msg, ProtocolVersion version) {
                return CBUtil.sizeOfStringMap(msg.options);
            }
        };
        private final Map<String, String> options;
        private final Map<String, String> additionalOptions;
        private final ProtocolOptions.Compression compression;
        private final boolean noCompact;

        Startup(ProtocolOptions.Compression compression, boolean noCompact, Map<String, String> additionalOptions) {
            super(Message.Request.Type.STARTUP);
            this.compression = compression;
            this.noCompact = noCompact;
            this.additionalOptions = additionalOptions;
            ImmutableMap.Builder map = new ImmutableMap.Builder();
            map.put((Object)CQL_VERSION_OPTION, (Object)CQL_VERSION);
            if (compression != ProtocolOptions.Compression.NONE) {
                map.put((Object)COMPRESSION_OPTION, (Object)compression.toString());
            }
            if (noCompact) {
                map.put((Object)NO_COMPACT_OPTION, (Object)"true");
            }
            map.put((Object)DRIVER_VERSION_OPTION, (Object)Cluster.getDriverVersion());
            map.put((Object)DRIVER_NAME_OPTION, (Object)DRIVER_NAME);
            map.putAll(additionalOptions);
            this.options = map.build();
        }

        @Override
        protected Message.Request copyInternal() {
            return new Startup(this.compression, this.noCompact, this.additionalOptions);
        }

        public String toString() {
            return "STARTUP " + this.options;
        }
    }
}

