/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ProtocolVersion;

enum ProtocolFeature {
    KEYSPACE_ON_QUERY,
    PREPARED_METADATA_CHANGES,
    CUSTOM_PAYLOADS,
    CLIENT_TIMESTAMPS;


    boolean isSupportedBy(ProtocolVersion version) {
        switch (this) {
            case KEYSPACE_ON_QUERY: {
                return version == ProtocolVersion.V5 || version == ProtocolVersion.DSE_V2;
            }
            case PREPARED_METADATA_CHANGES: {
                return version == ProtocolVersion.V5 || version == ProtocolVersion.DSE_V2;
            }
            case CUSTOM_PAYLOADS: {
                return version.compareTo(ProtocolVersion.V4) >= 0;
            }
            case CLIENT_TIMESTAMPS: {
                return version.compareTo(ProtocolVersion.V3) >= 0;
            }
        }
        return false;
    }
}

