/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

public class ContinuousPagingOptions {
    private final int pageSize;
    private final PageUnit pageUnit;
    private final int maxPages;
    private final int maxPagesPerSecond;
    private final int maxEnqueuedPages;

    public static Builder builder() {
        return new Builder();
    }

    private ContinuousPagingOptions(int pageSize, PageUnit pageUnit, int maxPages, int maxPagesPerSecond, int maxEnqueuedPages) {
        this.pageSize = pageSize;
        this.pageUnit = pageUnit;
        this.maxPages = maxPages;
        this.maxPagesPerSecond = maxPagesPerSecond;
        this.maxEnqueuedPages = maxEnqueuedPages;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public PageUnit getPageUnit() {
        return this.pageUnit;
    }

    public int getMaxPages() {
        return this.maxPages;
    }

    public int getMaxPagesPerSecond() {
        return this.maxPagesPerSecond;
    }

    public int getMaxEnqueuedPages() {
        return this.maxEnqueuedPages;
    }

    public String toString() {
        return String.format("continuous-paging-options=%d %s,%d,%d", this.pageSize, this.pageUnit.name(), this.maxPages, this.maxPagesPerSecond);
    }

    public static class Builder {
        private int pageSize = 5000;
        private PageUnit pageUnit = PageUnit.ROWS;
        private int maxPages;
        private int maxPagesPerSecond;
        private int maxEnqueuedPages = 4;

        public Builder withPageSize(int pageSize, PageUnit pageUnit) {
            this.pageSize = pageSize;
            this.pageUnit = pageUnit;
            return this;
        }

        public Builder withMaxPages(int maxPages) {
            this.maxPages = maxPages;
            return this;
        }

        public Builder withMaxPagesPerSecond(int maxPagesPerSecond) {
            this.maxPagesPerSecond = maxPagesPerSecond;
            return this;
        }

        public Builder withMaxEnqueuedPages(int maxEnqueuedPages) {
            if (maxEnqueuedPages <= 0) {
                throw new IllegalArgumentException("maxEnqueuedPages must be positive");
            }
            this.maxEnqueuedPages = maxEnqueuedPages;
            return this;
        }

        public ContinuousPagingOptions build() {
            return new ContinuousPagingOptions(this.pageSize, this.pageUnit, this.maxPages, this.maxPagesPerSecond, this.maxEnqueuedPages);
        }
    }

    public static enum PageUnit {
        BYTES(1),
        ROWS(2);

        public final int id;

        private PageUnit(int id) {
            this.id = id;
        }
    }
}

