/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.search;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.dse.search.DateRange;
import java.nio.ByteBuffer;
import java.util.Date;

public class DateRangeCodec
extends TypeCodec<DateRange> {
    public static final String CLASS_NAME = "org.apache.cassandra.db.marshal.DateRangeType";
    public static final DataType.CustomType DATA_TYPE = DataType.custom("org.apache.cassandra.db.marshal.DateRangeType");
    public static final DateRangeCodec INSTANCE = new DateRangeCodec();
    private static final byte DATE_RANGE_TYPE_SINGLE_DATE = 0;
    private static final byte DATE_RANGE_TYPE_CLOSED_RANGE = 1;
    private static final byte DATE_RANGE_TYPE_OPEN_RANGE_HIGH = 2;
    private static final byte DATE_RANGE_TYPE_OPEN_RANGE_LOW = 3;
    private static final byte DATE_RANGE_TYPE_BOTH_OPEN_RANGE = 4;
    private static final byte DATE_RANGE_TYPE_SINGLE_DATE_OPEN = 5;

    private DateRangeCodec() {
        super((DataType)DATA_TYPE, DateRange.class);
    }

    @Override
    public ByteBuffer serialize(DateRange dateRange, ProtocolVersion protocolVersion) throws InvalidTypeException {
        DateRange.DateRangeBound upperBound;
        if (dateRange == null) {
            return null;
        }
        byte rangeType = this.encodeType(dateRange);
        int bufferSize = 1;
        if (!dateRange.getLowerBound().isUnbounded()) {
            bufferSize += 9;
        }
        if (!dateRange.isSingleBounded() && !dateRange.getUpperBound().isUnbounded()) {
            bufferSize += 9;
        }
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.put(rangeType);
        DateRange.DateRangeBound lowerBound = dateRange.getLowerBound();
        if (!lowerBound.isUnbounded()) {
            buffer.putLong(lowerBound.getTimestamp().getTime());
            buffer.put(lowerBound.getPrecision().encoding);
        }
        if (!dateRange.isSingleBounded() && !(upperBound = dateRange.getUpperBound()).isUnbounded()) {
            buffer.putLong(upperBound.getTimestamp().getTime());
            buffer.put(upperBound.getPrecision().encoding);
        }
        return (ByteBuffer)buffer.flip();
    }

    @Override
    public DateRange deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null || bytes.remaining() == 0) {
            return null;
        }
        byte type = bytes.get();
        switch (type) {
            case 0: {
                return new DateRange(this.deserializeDateRangeLowerBound(bytes));
            }
            case 1: {
                return new DateRange(this.deserializeDateRangeLowerBound(bytes), this.deserializeDateRangeUpperBound(bytes));
            }
            case 2: {
                return new DateRange(this.deserializeDateRangeLowerBound(bytes), DateRange.DateRangeBound.UNBOUNDED);
            }
            case 3: {
                return new DateRange(DateRange.DateRangeBound.UNBOUNDED, this.deserializeDateRangeUpperBound(bytes));
            }
            case 4: {
                return new DateRange(DateRange.DateRangeBound.UNBOUNDED, DateRange.DateRangeBound.UNBOUNDED);
            }
            case 5: {
                return new DateRange(DateRange.DateRangeBound.UNBOUNDED);
            }
        }
        throw new InvalidTypeException("Unknown date range type: " + type);
    }

    @Override
    public DateRange parse(String value) throws InvalidTypeException {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        try {
            return DateRange.parse(ParseUtils.unquote(value));
        }
        catch (Exception e) {
            throw new InvalidTypeException(String.format("Invalid date range literal: %s", value), e);
        }
    }

    @Override
    public String format(DateRange dateRange) throws InvalidTypeException {
        return dateRange == null ? "NULL" : ParseUtils.quote(dateRange.toString());
    }

    private byte encodeType(DateRange dateRange) {
        if (dateRange.isSingleBounded()) {
            return dateRange.getLowerBound().isUnbounded() ? (byte)5 : 0;
        }
        if (dateRange.getLowerBound().isUnbounded()) {
            return dateRange.getUpperBound().isUnbounded() ? (byte)4 : 3;
        }
        return dateRange.getUpperBound().isUnbounded() ? (byte)2 : 1;
    }

    private DateRange.DateRangeBound deserializeDateRangeLowerBound(ByteBuffer bytes) {
        long epochMillis = bytes.getLong();
        DateRange.DateRangeBound.Precision precision = DateRange.DateRangeBound.Precision.fromEncoding(bytes.get());
        return DateRange.DateRangeBound.lowerBound(new Date(epochMillis), precision);
    }

    private DateRange.DateRangeBound deserializeDateRangeUpperBound(ByteBuffer bytes) {
        long epochMillis = bytes.getLong();
        DateRange.DateRangeBound.Precision precision = DateRange.DateRangeBound.Precision.fromEncoding(bytes.get());
        return DateRange.DateRangeBound.upperBound(new Date(epochMillis), precision);
    }
}

