/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathUtil {
    private static final Logger LOGGER;
    private static final boolean JSR_310_AVAILABLE;

    public static boolean isJavaTimeAvailable() {
        return JSR_310_AVAILABLE;
    }

    static {
        boolean jsr310Available;
        LOGGER = LoggerFactory.getLogger(ClasspathUtil.class);
        try {
            Class.forName("java.time.Instant");
            jsr310Available = true;
        }
        catch (LinkageError e) {
            jsr310Available = false;
            LOGGER.warn("JSR 310 could not be loaded", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            jsr310Available = false;
        }
        JSR_310_AVAILABLE = jsr310Available;
    }
}

