/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Authenticator;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.exceptions.AuthenticationException;
import java.net.InetSocketAddress;

public interface AuthProvider {
    public static final AuthProvider NONE = new NoAuthProvider();

    public Authenticator newAuthenticator(InetSocketAddress var1, String var2) throws AuthenticationException;

    public static class TransitionalModePlainTextAuthenticator
    extends PlainTextAuthProvider.PlainTextAuthenticator {
        public TransitionalModePlainTextAuthenticator() {
            super("", "");
        }
    }

    public static class NoAuthProvider
    implements AuthProvider {
        private static final String DSE_AUTHENTICATOR = "com.datastax.bdp.cassandra.auth.DseAuthenticator";
        static final String NO_AUTHENTICATOR_MESSAGE = "Host %s requires authentication, but no authenticator found in Cluster configuration";

        @Override
        public Authenticator newAuthenticator(InetSocketAddress host, String authenticator) {
            if (authenticator.equals(DSE_AUTHENTICATOR)) {
                return new TransitionalModePlainTextAuthenticator();
            }
            throw new AuthenticationException(host, String.format(NO_AUTHENTICATOR_MESSAGE, host));
        }
    }
}

