/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.GraphProtocol;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.RegularGraphStatement;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleGraphStatement
extends RegularGraphStatement {
    private static final Logger logger = LoggerFactory.getLogger(SimpleGraphStatement.class);
    private static final AtomicBoolean WARNED_GRAPHSON1 = new AtomicBoolean(false);
    private final String query;
    private final Map<String, Object> valuesMap;
    private boolean needsRebuild = true;
    private SimpleStatement statement;
    private ConsistencyLevel nativeConsistencyLevel;
    private long defaultTimestamp = Long.MIN_VALUE;
    private volatile int readTimeoutMillis = Integer.MIN_VALUE;
    private String authorizationId;

    public SimpleGraphStatement(String query) {
        this(query, new HashMap<String, Object>());
    }

    public SimpleGraphStatement(String query, Map<String, Object> valuesMap) {
        Preconditions.checkNotNull(valuesMap, (Object)"Parameter valuesMap cannot be null");
        this.query = query;
        this.valuesMap = valuesMap;
    }

    @Override
    public String getQueryString() {
        return this.query;
    }

    public SimpleGraphStatement set(String name, Object value) {
        this.valuesMap.put(name, value);
        this.needsRebuild = true;
        return this;
    }

    @Override
    public GraphStatement setConsistencyLevel(ConsistencyLevel consistencyLevel) {
        this.needsRebuild = true;
        this.nativeConsistencyLevel = consistencyLevel;
        return this;
    }

    @Override
    public ConsistencyLevel getConsistencyLevel() {
        return this.nativeConsistencyLevel;
    }

    @Override
    public GraphStatement setDefaultTimestamp(long defaultTimestamp) {
        this.needsRebuild = true;
        this.defaultTimestamp = defaultTimestamp;
        return this;
    }

    @Override
    public int getReadTimeoutMillis() {
        return this.readTimeoutMillis;
    }

    @Override
    public GraphStatement setReadTimeoutMillis(int readTimeoutMillis) {
        Preconditions.checkArgument((readTimeoutMillis >= 0 ? 1 : 0) != 0, (Object)"read timeout must be >= 0");
        this.readTimeoutMillis = readTimeoutMillis;
        this.needsRebuild = true;
        return this;
    }

    @Override
    public long getDefaultTimestamp() {
        return this.defaultTimestamp;
    }

    @Override
    public SimpleStatement unwrap() {
        return this.unwrap(GraphProtocol.GRAPHSON_1_0);
    }

    @Override
    public SimpleStatement unwrap(GraphProtocol graphProtocol) {
        this.maybeRebuildCache(graphProtocol);
        if (graphProtocol != GraphProtocol.GRAPHSON_1_0) {
            this.setTransformResultFunction(GraphJsonUtils.ROW_TO_GRAPHSON2_OBJECTGRAPHNODE);
        } else if (WARNED_GRAPHSON1.compareAndSet(false, true)) {
            logger.warn("GraphSON1 is being used for a graph query, however it is recommended to switch to GraphSON2 when executing a graph query to maintain type information in requests and responses to the DSE Graph server. Enabling GraphSON2 can be done via the DseCluster's GraphOptions, see https://goo.gl/EAUBUv for more information.");
        }
        return this.statement;
    }

    @Override
    public GraphStatement executingAs(String userOrRole) {
        this.authorizationId = userOrRole;
        this.needsRebuild = true;
        return this;
    }

    private void maybeRebuildCache(GraphProtocol graphProtocol) {
        if (this.needsRebuild) {
            if (this.valuesMap.isEmpty()) {
                this.statement = new SimpleStatement(this.query);
            } else {
                String values = graphProtocol == GraphProtocol.GRAPHSON_1_0 ? GraphJsonUtils.writeValueAsString(this.valuesMap) : GraphJsonUtils.writeValueAsStringGraphson20(this.valuesMap);
                this.statement = new SimpleStatement(this.query, values);
            }
            if (this.getConsistencyLevel() != null) {
                this.statement.setConsistencyLevel(this.nativeConsistencyLevel);
            }
            if (this.getDefaultTimestamp() != Long.MIN_VALUE) {
                this.statement.setDefaultTimestamp(this.defaultTimestamp);
            }
            if (this.getReadTimeoutMillis() != Integer.MIN_VALUE) {
                this.statement.setReadTimeoutMillis(this.readTimeoutMillis);
            }
            if (this.authorizationId != null) {
                this.statement.executingAs(this.authorizationId);
            }
            this.needsRebuild = false;
        }
    }
}

