/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.DefaultEdge;
import com.datastax.driver.dse.graph.DefaultPath;
import com.datastax.driver.dse.graph.DefaultProperty;
import com.datastax.driver.dse.graph.DefaultVertex;
import com.datastax.driver.dse.graph.DefaultVertexProperty;
import com.datastax.driver.dse.graph.Edge;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphSON2JacksonModule;
import com.datastax.driver.dse.graph.ObjectGraphNode;
import com.datastax.driver.dse.graph.Path;
import com.datastax.driver.dse.graph.Property;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import com.datastax.shaded.jackson.core.JsonGenerator;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.core.JsonProcessingException;
import com.datastax.shaded.jackson.core.JsonToken;
import com.datastax.shaded.jackson.databind.DeserializationContext;
import com.datastax.shaded.jackson.databind.JavaType;
import com.datastax.shaded.jackson.databind.JsonNode;
import com.datastax.shaded.jackson.databind.SerializerProvider;
import com.datastax.shaded.jackson.databind.deser.std.StdDeserializer;
import com.datastax.shaded.jackson.databind.node.ArrayNode;
import com.datastax.shaded.jackson.databind.ser.std.StdScalarSerializer;
import com.datastax.shaded.jackson.databind.type.TypeFactory;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class GraphSON2GremlinDriverModule
extends GraphSON2JacksonModule {
    GraphSON2GremlinDriverModule() {
        super("graph-graphson2gremlin");
        this.addSerializer(Integer.class, new IntegerGraphSONSerializer());
        this.addSerializer(Double.class, new DoubleGraphSONSerializer());
        this.addDeserializer(Vertex.class, new VertexGraphSON2Deserializer());
        this.addDeserializer(VertexProperty.class, new VertexPropertyGraphSON2Deserializer());
        this.addDeserializer(Property.class, new PropertyGraphSON2Deserializer());
        this.addDeserializer(Edge.class, new EdgeGraphSON2Deserializer());
        this.addDeserializer(Path.class, new PathGraphSON2Deserializer());
    }

    @Override
    public Map<Class<?>, String> getTypeDefinitions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Integer.class, (Object)"Int32");
        builder.put(Long.class, (Object)"Int64");
        builder.put(Double.class, (Object)"Double");
        builder.put(Float.class, (Object)"Float");
        builder.put(Vertex.class, (Object)"Vertex");
        builder.put(VertexProperty.class, (Object)"VertexProperty");
        builder.put(Property.class, (Object)"Property");
        builder.put(Edge.class, (Object)"Edge");
        builder.put(Path.class, (Object)"Path");
        builder.put(List.class, (Object)"Tree");
        return builder.build();
    }

    @Override
    public String getTypeNamespace() {
        return "g";
    }

    static final class PathGraphSON2Deserializer
    extends StdDeserializer<Path> {
        private static final JavaType setType = TypeFactory.defaultInstance().constructCollectionType(HashSet.class, String.class);

        PathGraphSON2Deserializer() {
            super(Path.class);
        }

        @Override
        public Path deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            JsonNode n = (JsonNode)jsonParser.readValueAsTree();
            DefaultPath p = new DefaultPath();
            ArrayNode objects = (ArrayNode)n.get("objects");
            ArrayNode labels = (ArrayNode)n.get("labels");
            ArrayList<GraphNode> objectsList = new ArrayList<GraphNode>();
            ArrayList<Set<String>> labelsList = new ArrayList<Set<String>>();
            for (int i = 0; i < objects.size(); ++i) {
                JsonParser po = objects.get(i).traverse();
                po.nextToken();
                JsonParser pl = labels.get(i).traverse();
                pl.nextToken();
                objectsList.add(new ObjectGraphNode(deserializationContext.readValue(po, Object.class)));
                labelsList.add((Set)deserializationContext.readValue(pl, setType));
            }
            p.objects = objectsList;
            p.labels = labelsList;
            return p;
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class PropertyGraphSON2Deserializer
    extends StdDeserializer<Property> {
        PropertyGraphSON2Deserializer() {
            super(Property.class);
        }

        @Override
        public Property deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DefaultProperty prop = new DefaultProperty();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("key")) {
                    jsonParser.nextToken();
                    prop.name = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("value")) continue;
                jsonParser.nextToken();
                prop.value = new ObjectGraphNode(deserializationContext.readValue(jsonParser, Object.class));
            }
            return prop;
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class EdgeGraphSON2Deserializer
    extends StdDeserializer<Edge> {
        EdgeGraphSON2Deserializer() {
            super(Edge.class);
        }

        @Override
        public Edge deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DefaultEdge e = new DefaultEdge();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("id")) {
                    jsonParser.nextToken();
                    e.id = new ObjectGraphNode(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("label")) {
                    jsonParser.nextToken();
                    e.label = jsonParser.getText();
                    continue;
                }
                if (jsonParser.getCurrentName().equals("outV")) {
                    jsonParser.nextToken();
                    e.outV = new ObjectGraphNode(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("outVLabel")) {
                    jsonParser.nextToken();
                    e.outVLabel = jsonParser.getText();
                    continue;
                }
                if (jsonParser.getCurrentName().equals("inV")) {
                    jsonParser.nextToken();
                    e.inV = new ObjectGraphNode(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("inVLabel")) {
                    jsonParser.nextToken();
                    e.inVLabel = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("properties")) continue;
                jsonParser.nextToken();
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    jsonParser.nextToken();
                    DefaultProperty prop = (DefaultProperty)deserializationContext.readValue(jsonParser, Property.class);
                    prop.parent = e;
                    builder.put((Object)prop.name, (Object)new ObjectGraphNode(prop));
                }
                e.properties = builder.build();
            }
            return e;
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class VertexPropertyGraphSON2Deserializer
    extends StdDeserializer<VertexProperty> {
        VertexPropertyGraphSON2Deserializer() {
            super(VertexProperty.class);
        }

        @Override
        public VertexProperty deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DefaultVertexProperty vp = new DefaultVertexProperty();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("id")) {
                    jsonParser.nextToken();
                    vp.id = new ObjectGraphNode(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("label")) {
                    jsonParser.nextToken();
                    vp.label = jsonParser.getText();
                    continue;
                }
                if (jsonParser.getCurrentName().equals("value")) {
                    jsonParser.nextToken();
                    vp.value = new ObjectGraphNode(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("properties")) continue;
                jsonParser.nextToken();
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    String key = jsonParser.getCurrentName();
                    jsonParser.nextToken();
                    Object val = deserializationContext.readValue(jsonParser, Object.class);
                    DefaultProperty prop = new DefaultProperty();
                    prop.name = key;
                    prop.value = new ObjectGraphNode(val);
                    prop.parent = vp;
                    builder.put((Object)prop.name, (Object)new ObjectGraphNode(prop));
                }
                vp.properties = builder.build();
            }
            return vp;
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class VertexGraphSON2Deserializer
    extends StdDeserializer<Vertex> {
        VertexGraphSON2Deserializer() {
            super(Vertex.class);
        }

        @Override
        public Vertex deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            DefaultVertex v = new DefaultVertex();
            while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                if (jsonParser.getCurrentName().equals("id")) {
                    jsonParser.nextToken();
                    v.id = new ObjectGraphNode(deserializationContext.readValue(jsonParser, Object.class));
                    continue;
                }
                if (jsonParser.getCurrentName().equals("label")) {
                    jsonParser.nextToken();
                    v.label = jsonParser.getText();
                    continue;
                }
                if (!jsonParser.getCurrentName().equals("properties")) continue;
                jsonParser.nextToken();
                ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
                while (jsonParser.nextToken() != JsonToken.END_OBJECT) {
                    jsonParser.nextToken();
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        DefaultVertexProperty vp = (DefaultVertexProperty)deserializationContext.readValue(jsonParser, VertexProperty.class);
                        vp.parent = v;
                        builder.put((Object)vp.getName(), (Object)new ObjectGraphNode(vp));
                    }
                }
                v.properties = builder.build();
            }
            return v;
        }

        @Override
        public boolean isCachable() {
            return true;
        }
    }

    static final class DoubleGraphSONSerializer
    extends StdScalarSerializer<Double> {
        DoubleGraphSONSerializer() {
            super(Double.class);
        }

        @Override
        public void serialize(Double doubleValue, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(doubleValue);
        }
    }

    static final class IntegerGraphSONSerializer
    extends StdScalarSerializer<Integer> {
        IntegerGraphSONSerializer() {
            super(Integer.class);
        }

        @Override
        public void serialize(Integer integer, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
            jsonGenerator.writeNumber(integer);
        }
    }
}

