/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.dse.graph.Edge;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.Path;
import com.datastax.driver.dse.graph.Property;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import com.datastax.shaded.jackson.core.JsonParser;
import com.datastax.shaded.jackson.databind.JavaType;
import com.datastax.shaded.jackson.databind.JsonNode;
import com.datastax.shaded.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Iterator;
import java.util.Map;

class DefaultGraphNode
implements GraphNode {
    private static final String TYPE = "type";
    private static final String VERTEX_TYPE = "vertex";
    private static final String EDGE_TYPE = "edge";
    private static final TypeToken<Map<String, Object>> MAP_TYPE = new TypeToken<Map<String, Object>>(){};
    final JsonNode delegate;
    final ObjectMapper objectMapper;

    DefaultGraphNode(JsonNode delegate, ObjectMapper objectMapper) {
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkNotNull((Object)objectMapper);
        this.delegate = delegate;
        this.objectMapper = objectMapper;
    }

    @Override
    public DefaultGraphNode get(String fieldName) {
        JsonNode node = this.delegate.get(fieldName);
        if (node == null) {
            return null;
        }
        return new DefaultGraphNode(node, this.objectMapper);
    }

    @Override
    public DefaultGraphNode get(int index) {
        JsonNode node = this.delegate.get(index);
        if (node == null) {
            return null;
        }
        return new DefaultGraphNode(node, this.objectMapper);
    }

    @Override
    public int asInt() {
        return this.delegate.asInt();
    }

    @Override
    public boolean asBoolean() {
        return this.delegate.asBoolean();
    }

    @Override
    public long asLong() {
        return this.delegate.asLong();
    }

    @Override
    public double asDouble() {
        return this.delegate.asDouble();
    }

    @Override
    public String asString() {
        return this.delegate.asText();
    }

    @Override
    public Map<String, Object> asMap() {
        return this.as(MAP_TYPE);
    }

    @Override
    public boolean isVertex() {
        JsonNode type = this.delegate.get(TYPE);
        return type != null && VERTEX_TYPE.equals(type.asText());
    }

    @Override
    public boolean isEdge() {
        JsonNode type = this.delegate.get(TYPE);
        return type != null && EDGE_TYPE.equals(type.asText());
    }

    @Override
    public Vertex asVertex() {
        return this.as(Vertex.class);
    }

    @Override
    public Edge asEdge() {
        return this.as(Edge.class);
    }

    @Override
    public Path asPath() {
        return this.as(Path.class);
    }

    @Override
    public Property asProperty() {
        return this.as(Property.class);
    }

    @Override
    public VertexProperty asVertexProperty() {
        return this.as(VertexProperty.class);
    }

    @Override
    public <T> T as(Class<T> clazz) {
        try {
            return this.objectMapper.treeToValue(this.delegate, clazz);
        }
        catch (Exception e) {
            throw new DriverException("Cannot deserialize node as " + clazz, e);
        }
    }

    @Override
    public <T> T as(TypeToken<T> type) {
        try {
            JsonParser parser = this.objectMapper.treeAsTokens(this.delegate);
            JavaType javaType = this.objectMapper.constructType(type.getType());
            return this.objectMapper.readValue(parser, javaType);
        }
        catch (Exception e) {
            throw new DriverException("Cannot deserialize node as " + type, e);
        }
    }

    @Override
    public boolean isNull() {
        return this.delegate.isNull();
    }

    @Override
    public boolean isObject() {
        return this.delegate.isObject();
    }

    @Override
    public boolean isArray() {
        return this.delegate.isArray();
    }

    @Override
    public boolean isValue() {
        return this.delegate.isValueNode();
    }

    @Override
    public Iterator<String> fieldNames() {
        return this.delegate.fieldNames();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultGraphNode)) {
            return false;
        }
        DefaultGraphNode that = (DefaultGraphNode)o;
        return Objects.equal((Object)this.delegate, (Object)that.delegate);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.delegate});
    }

    public String toString() {
        return this.delegate.toString();
    }
}

