/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.mapping.PropertyMapper;
import com.datastax.driver.mapping.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;

class EntityMapper<T> {
    private final Class<T> entityClass;
    final String keyspace;
    final String table;
    final ConsistencyLevel writeConsistency;
    final ConsistencyLevel readConsistency;
    final List<PropertyMapper> partitionKeys = new ArrayList<PropertyMapper>();
    final List<PropertyMapper> clusteringColumns = new ArrayList<PropertyMapper>();
    final List<PropertyMapper> allColumns = new ArrayList<PropertyMapper>();

    EntityMapper(Class<T> entityClass, String keyspace, String table, ConsistencyLevel writeConsistency, ConsistencyLevel readConsistency) {
        this.entityClass = entityClass;
        this.keyspace = keyspace;
        this.table = table;
        this.writeConsistency = writeConsistency;
        this.readConsistency = readConsistency;
    }

    int primaryKeySize() {
        return this.partitionKeys.size() + this.clusteringColumns.size();
    }

    PropertyMapper getPrimaryKeyColumn(int i) {
        return i < this.partitionKeys.size() ? this.partitionKeys.get(i) : this.clusteringColumns.get(i - this.partitionKeys.size());
    }

    void addColumns(List<PropertyMapper> pks, List<PropertyMapper> ccs, List<PropertyMapper> rgs) {
        this.partitionKeys.addAll(pks);
        this.clusteringColumns.addAll(ccs);
        this.allColumns.addAll(pks);
        this.allColumns.addAll(ccs);
        this.allColumns.addAll(rgs);
    }

    T newEntity() {
        return ReflectionUtils.newInstance(this.entityClass);
    }
}

