/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Result<T>
implements Iterable<T> {
    private final ResultSet rs;
    private final EntityMapper<T> mapper;
    private final ProtocolVersion protocolVersion;
    private final boolean useAlias;

    Result(ResultSet rs, EntityMapper<T> mapper, ProtocolVersion protocolVersion, boolean useAlias) {
        this.rs = rs;
        this.mapper = mapper;
        this.protocolVersion = protocolVersion;
        this.useAlias = useAlias;
    }

    private T map(Row row) {
        T entity = this.mapper.newEntity();
        for (ColumnMapper<T> cm : this.mapper.allColumns()) {
            ByteBuffer bytes;
            String name;
            String string = name = cm.getAlias() != null && this.useAlias ? cm.getAlias() : cm.getColumnName();
            if (!row.getColumnDefinitions().contains(name) || (bytes = row.getBytesUnsafe(name)) == null) continue;
            cm.setValue(entity, cm.getDataType().deserialize(bytes, this.protocolVersion));
        }
        return entity;
    }

    public boolean isExhausted() {
        return this.rs.isExhausted();
    }

    public T one() {
        Row row = this.rs.one();
        return row == null ? null : (T)this.map(row);
    }

    public List<T> all() {
        List rows = this.rs.all();
        ArrayList<T> entities = new ArrayList<T>(rows.size());
        for (Row row : rows) {
            entities.add(this.map(row));
        }
        return entities;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<Row> rowIterator;
            {
                this.rowIterator = Result.this.rs.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.rowIterator.hasNext();
            }

            @Override
            public T next() {
                return Result.this.map(this.rowIterator.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ExecutionInfo getExecutionInfo() {
        return this.rs.getExecutionInfo();
    }
}

