/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.mapping.AnnotationParser;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.EnumType;
import com.datastax.driver.mapping.InferredCQLType;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.TypeMappings;
import com.datastax.driver.mapping.UDTMapper;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

class ReflectionMapper<T>
extends EntityMapper<T> {
    private static ReflectionFactory factory = new ReflectionFactory();

    private ReflectionMapper(Class<T> entityClass, String keyspace, String table, ConsistencyLevel writeConsistency, ConsistencyLevel readConsistency) {
        super(entityClass, keyspace, table, writeConsistency, readConsistency);
    }

    public static EntityMapper.Factory factory() {
        return factory;
    }

    @Override
    public T newEntity() {
        try {
            return this.entityClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create an instance of " + this.entityClass.getName());
        }
    }

    static DataType extractSimpleType(Field f) {
        Type type = f.getGenericType();
        assert (!(type instanceof ParameterizedType));
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException(String.format("Cannot map class %s for field %s", type, f.getName()));
        }
        return TypeMappings.getSimpleType((Class)type, f.getName());
    }

    private static class ReflectionFactory
    implements EntityMapper.Factory {
        private ReflectionFactory() {
        }

        @Override
        public <T> EntityMapper<T> create(Class<T> entityClass, String keyspace, String table, ConsistencyLevel writeConsistency, ConsistencyLevel readConsistency) {
            return new ReflectionMapper(entityClass, keyspace, table, writeConsistency, readConsistency);
        }

        @Override
        public <T> ColumnMapper<T> createColumnMapper(Class<T> entityClass, Field field, int position, MappingManager mappingManager, AtomicInteger columnCounter) {
            String fieldName = field.getName();
            try {
                PropertyDescriptor pd = new PropertyDescriptor(fieldName, field.getDeclaringClass());
                if (field.getType().isEnum()) {
                    return new EnumMapper(field, position, pd, AnnotationParser.enumType(field), columnCounter);
                }
                if (TypeMappings.isMappedUDT(field.getType())) {
                    UDTMapper<?> udtMapper = mappingManager.getUDTMapper(field.getType());
                    return new UDTColumnMapper(field, position, pd, udtMapper, columnCounter);
                }
                if (field.getGenericType() instanceof ParameterizedType) {
                    InferredCQLType inferredCQLType = InferredCQLType.from(field, mappingManager);
                    if (inferredCQLType.containsMappedUDT) {
                        return new NestedUDTMapper(field, position, pd, inferredCQLType, columnCounter);
                    }
                    return new LiteralMapper(field, inferredCQLType.dataType, position, pd, columnCounter);
                }
                return new LiteralMapper(field, position, pd, columnCounter);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Cannot find matching getter and setter for field '" + fieldName + "'");
            }
        }
    }

    private static class NestedUDTMapper<T>
    extends LiteralMapper<T> {
        private final InferredCQLType inferredCQLType;

        public NestedUDTMapper(Field field, int position, PropertyDescriptor pd, InferredCQLType inferredCQLType, AtomicInteger columnCounter) {
            super(field, inferredCQLType.dataType, position, pd, columnCounter);
            this.inferredCQLType = inferredCQLType;
        }

        @Override
        public void setValue(Object entity, Object valueWithUDTValues) {
            super.setValue(entity, UDTMapper.convertUDTsToEntities(valueWithUDTValues, this.inferredCQLType));
        }

        @Override
        Object toSerializableValue(Object value) {
            return UDTMapper.convertEntitiesToUDTs(value, this.inferredCQLType);
        }
    }

    private static class UDTColumnMapper<T, U>
    extends LiteralMapper<T> {
        private final UDTMapper<U> udtMapper;

        private UDTColumnMapper(Field field, int position, PropertyDescriptor pd, UDTMapper<U> udtMapper, AtomicInteger columnCounter) {
            super(field, (DataType)udtMapper.getUserType(), position, pd, columnCounter);
            this.udtMapper = udtMapper;
        }

        @Override
        void setValue(Object entity, Object value) {
            assert (value instanceof UDTValue);
            UDTValue udtValue = (UDTValue)value;
            assert (udtValue.getType().equals((Object)this.udtMapper.getUserType()));
            super.setValue(entity, (Object)this.udtMapper.toEntity(udtValue));
        }

        @Override
        Object toSerializableValue(Object value) {
            if (value == null) {
                return null;
            }
            Object mappedUdt = value;
            return this.udtMapper.toUDT(mappedUdt);
        }
    }

    private static class EnumMapper<T>
    extends LiteralMapper<T> {
        private final EnumType enumType;
        private final Map<String, Object> fromString;

        private EnumMapper(Field field, int position, PropertyDescriptor pd, EnumType enumType, AtomicInteger columnCounter) {
            super(field, enumType == EnumType.STRING ? DataType.text() : DataType.cint(), position, pd, columnCounter);
            this.enumType = enumType;
            if (enumType == EnumType.STRING) {
                this.fromString = new HashMap<String, Object>(this.javaType.getEnumConstants().length);
                for (Object constant : this.javaType.getEnumConstants()) {
                    this.fromString.put(constant.toString().toLowerCase(), constant);
                }
            } else {
                this.fromString = null;
            }
        }

        @Override
        void setValue(Object entity, Object value) {
            Object converted = null;
            switch (this.enumType) {
                case STRING: {
                    converted = this.fromString.get(value.toString().toLowerCase());
                    break;
                }
                case ORDINAL: {
                    converted = this.javaType.getEnumConstants()[(Integer)value];
                }
            }
            super.setValue(entity, converted);
        }

        @Override
        Object toSerializableValue(Object value) {
            switch (this.enumType) {
                case STRING: {
                    return value == null ? null : value.toString();
                }
                case ORDINAL: {
                    return value == null ? null : Integer.valueOf(((Enum)value).ordinal());
                }
            }
            throw new AssertionError();
        }
    }

    private static class LiteralMapper<T>
    extends ColumnMapper<T> {
        private final Method readMethod;
        private final Method writeMethod;

        private LiteralMapper(Field field, int position, PropertyDescriptor pd, AtomicInteger columnNumber) {
            this(field, ReflectionMapper.extractSimpleType(field), position, pd, columnNumber);
        }

        private LiteralMapper(Field field, DataType type, int position, PropertyDescriptor pd, AtomicInteger columnCounter) {
            super(field, type, position, columnCounter);
            this.readMethod = pd.getReadMethod();
            this.writeMethod = pd.getWriteMethod();
        }

        @Override
        Object getValue(T entity) {
            try {
                return this.toSerializableValue(this.readMethod.invoke(entity, new Object[0]));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not get field '" + this.fieldName + "'");
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access getter for '" + this.fieldName + "' in " + entity.getClass().getName(), e);
            }
        }

        @Override
        void setValue(Object entity, Object value) {
            try {
                this.writeMethod.invoke(entity, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not set field '" + this.fieldName + "' to value '" + value + "'");
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access setter for '" + this.fieldName + "' in " + entity.getClass().getName(), e);
            }
        }
    }
}

