/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.mapping;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.mapping.AnnotationParser;
import com.datastax.driver.mapping.ColumnMapper;
import com.datastax.driver.mapping.EntityMapper;
import com.datastax.driver.mapping.EnumType;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.ReflectionUtils;
import com.datastax.driver.mapping.UDTMapper;
import com.datastax.driver.mapping.annotations.UDT;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class ReflectionMapper<T>
extends EntityMapper<T> {
    private static ReflectionFactory factory = new ReflectionFactory();

    private ReflectionMapper(Class<T> entityClass, String keyspace, String table, ConsistencyLevel writeConsistency, ConsistencyLevel readConsistency) {
        super(entityClass, keyspace, table, writeConsistency, readConsistency);
    }

    public static EntityMapper.Factory factory() {
        return factory;
    }

    @Override
    public T newEntity() {
        try {
            return this.entityClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't create an instance of " + this.entityClass.getName());
        }
    }

    static DataType extractType(Field f) {
        Type type = f.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type raw = pt.getRawType();
            if (!(raw instanceof Class)) {
                throw new IllegalArgumentException(String.format("Cannot map class %s for field %s", type, f.getName()));
            }
            Class klass = (Class)raw;
            if (List.class.isAssignableFrom(klass)) {
                return DataType.list((DataType)ReflectionMapper.getSimpleType(ReflectionUtils.getParam(pt, 0, f.getName()), f));
            }
            if (Set.class.isAssignableFrom(klass)) {
                return DataType.set((DataType)ReflectionMapper.getSimpleType(ReflectionUtils.getParam(pt, 0, f.getName()), f));
            }
            if (Map.class.isAssignableFrom(klass)) {
                return DataType.map((DataType)ReflectionMapper.getSimpleType(ReflectionUtils.getParam(pt, 0, f.getName()), f), (DataType)ReflectionMapper.getSimpleType(ReflectionUtils.getParam(pt, 1, f.getName()), f));
            }
            throw new IllegalArgumentException(String.format("Cannot map class %s for field %s", type, f.getName()));
        }
        if (!(type instanceof Class)) {
            throw new IllegalArgumentException(String.format("Cannot map class %s for field %s", type, f.getName()));
        }
        return ReflectionMapper.getSimpleType((Class)type, f);
    }

    static DataType getSimpleType(Class<?> klass, Field f) {
        if (ByteBuffer.class.isAssignableFrom(klass)) {
            return DataType.blob();
        }
        if (klass == Integer.TYPE || Integer.class.isAssignableFrom(klass)) {
            return DataType.cint();
        }
        if (klass == Long.TYPE || Long.class.isAssignableFrom(klass)) {
            return DataType.bigint();
        }
        if (klass == Float.TYPE || Float.class.isAssignableFrom(klass)) {
            return DataType.cfloat();
        }
        if (klass == Double.TYPE || Double.class.isAssignableFrom(klass)) {
            return DataType.cdouble();
        }
        if (klass == Boolean.TYPE || Boolean.class.isAssignableFrom(klass)) {
            return DataType.cboolean();
        }
        if (BigDecimal.class.isAssignableFrom(klass)) {
            return DataType.decimal();
        }
        if (BigInteger.class.isAssignableFrom(klass)) {
            return DataType.decimal();
        }
        if (String.class.isAssignableFrom(klass)) {
            return DataType.text();
        }
        if (InetAddress.class.isAssignableFrom(klass)) {
            return DataType.inet();
        }
        if (Date.class.isAssignableFrom(klass)) {
            return DataType.timestamp();
        }
        if (UUID.class.isAssignableFrom(klass)) {
            return DataType.uuid();
        }
        if (Collection.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException(String.format("Cannot map non-parametrized collection type %s for field %s; Please use a concrete type parameter", klass.getName(), f.getName()));
        }
        throw new IllegalArgumentException(String.format("Cannot map unknown class %s for field %s", klass.getName(), f));
    }

    private static class ReflectionFactory
    implements EntityMapper.Factory {
        private ReflectionFactory() {
        }

        @Override
        public <T> EntityMapper<T> create(Class<T> entityClass, String keyspace, String table, ConsistencyLevel writeConsistency, ConsistencyLevel readConsistency) {
            return new ReflectionMapper(entityClass, keyspace, table, writeConsistency, readConsistency);
        }

        @Override
        public <T> ColumnMapper<T> createColumnMapper(Class<T> entityClass, Field field, int position, MappingManager mappingManager) {
            String fieldName = field.getName();
            try {
                PropertyDescriptor pd = new PropertyDescriptor(fieldName, field.getDeclaringClass());
                if (field.getType().isEnum()) {
                    return new EnumMapper(field, position, pd, AnnotationParser.enumType(field));
                }
                if (field.getType().isAnnotationPresent(UDT.class)) {
                    UDTMapper<?> udtMapper = mappingManager.getUDTMapper(field.getType());
                    return new UDTColumnMapper(field, position, pd, udtMapper);
                }
                if (field.getGenericType() instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)field.getGenericType();
                    Type raw = pt.getRawType();
                    if (!(raw instanceof Class)) {
                        throw new IllegalArgumentException(String.format("Cannot map class %s for field %s", field, field.getName()));
                    }
                    Class klass = (Class)raw;
                    Class<?> firstTypeParam = ReflectionUtils.getParam(pt, 0, field.getName());
                    if (List.class.isAssignableFrom(klass) && firstTypeParam.isAnnotationPresent(UDT.class)) {
                        UDTMapper<?> valueMapper = mappingManager.getUDTMapper(firstTypeParam);
                        return new UDTListMapper(field, position, pd, valueMapper);
                    }
                    if (Set.class.isAssignableFrom(klass) && firstTypeParam.isAnnotationPresent(UDT.class)) {
                        UDTMapper<?> valueMapper = mappingManager.getUDTMapper(firstTypeParam);
                        return new UDTSetMapper(field, position, pd, valueMapper);
                    }
                    if (Map.class.isAssignableFrom(klass)) {
                        UDTMapper<?> valueMapper;
                        Class<?> secondTypeParam = ReflectionUtils.getParam(pt, 1, field.getName());
                        UDTMapper<?> keyMapper = firstTypeParam.isAnnotationPresent(UDT.class) ? mappingManager.getUDTMapper(firstTypeParam) : null;
                        UDTMapper<?> uDTMapper = valueMapper = secondTypeParam.isAnnotationPresent(UDT.class) ? mappingManager.getUDTMapper(secondTypeParam) : null;
                        if (keyMapper != null || valueMapper != null) {
                            return new UDTMapMapper(field, position, pd, keyMapper, valueMapper, firstTypeParam, secondTypeParam);
                        }
                    }
                }
                return new LiteralMapper(field, position, pd);
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException("Cannot find matching getter and setter for field '" + fieldName + "'");
            }
        }
    }

    private static class UDTMapMapper<T, K, V>
    extends LiteralMapper<T> {
        private final UDTMapper<K> keyMapper;
        private final UDTMapper<V> valueMapper;

        UDTMapMapper(Field field, int position, PropertyDescriptor pd, UDTMapper<K> keyMapper, UDTMapper<V> valueMapper, Class<?> keyClass, Class<?> valueClass) {
            super(field, UDTMapMapper.buildDataType(field, keyMapper, valueMapper, keyClass, valueClass), position, pd);
            this.keyMapper = keyMapper;
            this.valueMapper = valueMapper;
        }

        @Override
        public Object getValue(T entity) {
            Map entities = (Map)super.getValue(entity);
            return UDTMapper.toUDTValues(entities, this.keyMapper, this.valueMapper);
        }

        @Override
        public void setValue(Object entity, Object fieldValue) {
            Map udtValues = (Map)fieldValue;
            super.setValue(entity, (Object)UDTMapper.toEntities(udtValues, this.keyMapper, this.valueMapper));
        }

        private static <K, V> DataType buildDataType(Field field, UDTMapper<K> keyMapper, UDTMapper<V> valueMapper, Class<?> keyClass, Class<?> valueClass) {
            assert (keyMapper != null || valueMapper != null);
            UserType keyType = keyMapper != null ? keyMapper.getUserType() : ReflectionMapper.getSimpleType(keyClass, field);
            UserType valueType = valueMapper != null ? valueMapper.getUserType() : ReflectionMapper.getSimpleType(valueClass, field);
            return DataType.map((DataType)keyType, (DataType)valueType);
        }
    }

    private static class UDTSetMapper<T, V>
    extends LiteralMapper<T> {
        private final UDTMapper<V> valueMapper;

        UDTSetMapper(Field field, int position, PropertyDescriptor pd, UDTMapper<V> valueMapper) {
            super(field, DataType.set((DataType)valueMapper.getUserType()), position, pd);
            this.valueMapper = valueMapper;
        }

        @Override
        public Object getValue(T entity) {
            Set entities = (Set)super.getValue(entity);
            return this.valueMapper.toUDTValues(entities);
        }

        @Override
        public void setValue(Object entity, Object value) {
            Set udtValues = (Set)value;
            super.setValue(entity, (Object)this.valueMapper.toEntities(udtValues));
        }
    }

    private static class UDTListMapper<T, V>
    extends LiteralMapper<T> {
        private final UDTMapper<V> valueMapper;

        UDTListMapper(Field field, int position, PropertyDescriptor pd, UDTMapper<V> valueMapper) {
            super(field, DataType.list((DataType)valueMapper.getUserType()), position, pd);
            this.valueMapper = valueMapper;
        }

        @Override
        public Object getValue(T entity) {
            List entities = (List)super.getValue(entity);
            return this.valueMapper.toUDTValues(entities);
        }

        @Override
        public void setValue(Object entity, Object value) {
            List udtValues = (List)value;
            super.setValue(entity, (Object)this.valueMapper.toEntities(udtValues));
        }
    }

    private static class UDTColumnMapper<T, U>
    extends LiteralMapper<T> {
        private final UDTMapper<U> udtMapper;

        private UDTColumnMapper(Field field, int position, PropertyDescriptor pd, UDTMapper<U> udtMapper) {
            super(field, (DataType)udtMapper.getUserType(), position, pd);
            this.udtMapper = udtMapper;
        }

        @Override
        public Object getValue(T entity) {
            Object udtEntity = super.getValue(entity);
            return this.udtMapper.toUDT(udtEntity);
        }

        @Override
        public void setValue(Object entity, Object value) {
            assert (value instanceof UDTValue);
            UDTValue udtValue = (UDTValue)value;
            assert (udtValue.getType().equals((Object)this.udtMapper.getUserType()));
            super.setValue(entity, (Object)this.udtMapper.toEntity(udtValue));
        }
    }

    private static class EnumMapper<T>
    extends LiteralMapper<T> {
        private final EnumType enumType;
        private final Map<String, Object> fromString;

        private EnumMapper(Field field, int position, PropertyDescriptor pd, EnumType enumType) {
            super(field, enumType == EnumType.STRING ? DataType.text() : DataType.cint(), position, pd);
            this.enumType = enumType;
            if (enumType == EnumType.STRING) {
                this.fromString = new HashMap<String, Object>(this.javaType.getEnumConstants().length);
                for (Object constant : this.javaType.getEnumConstants()) {
                    this.fromString.put(constant.toString().toLowerCase(), constant);
                }
            } else {
                this.fromString = null;
            }
        }

        @Override
        public Object getValue(T entity) {
            Object value = super.getValue(entity);
            switch (this.enumType) {
                case STRING: {
                    return value.toString();
                }
                case ORDINAL: {
                    return ((Enum)value).ordinal();
                }
            }
            throw new AssertionError();
        }

        @Override
        public void setValue(Object entity, Object value) {
            Object converted = null;
            switch (this.enumType) {
                case STRING: {
                    converted = this.fromString.get(value.toString().toLowerCase());
                    break;
                }
                case ORDINAL: {
                    converted = this.javaType.getEnumConstants()[(Integer)value];
                }
            }
            super.setValue(entity, converted);
        }
    }

    private static class LiteralMapper<T>
    extends ColumnMapper<T> {
        private final Method readMethod;
        private final Method writeMethod;

        private LiteralMapper(Field field, int position, PropertyDescriptor pd) {
            this(field, ReflectionMapper.extractType(field), position, pd);
        }

        private LiteralMapper(Field field, DataType type, int position, PropertyDescriptor pd) {
            super(field, type, position);
            this.readMethod = pd.getReadMethod();
            this.writeMethod = pd.getWriteMethod();
        }

        @Override
        public Object getValue(T entity) {
            try {
                return this.readMethod.invoke(entity, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not get field '" + this.fieldName + "'");
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access getter for '" + this.fieldName + "' in " + entity.getClass().getName(), e);
            }
        }

        @Override
        public void setValue(Object entity, Object value) {
            try {
                this.writeMethod.invoke(entity, value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not set field '" + this.fieldName + "' to value '" + value + "'");
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to access setter for '" + this.fieldName + "' in " + entity.getClass().getName(), e);
            }
        }
    }
}

