/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.json;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.utils.Bytes;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonException;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.JsonStructure;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;

public class Jsr353JsonCodec
extends TypeCodec<JsonStructure> {
    private final JsonReaderFactory readerFactory;
    private final JsonWriterFactory writerFactory;

    public Jsr353JsonCodec() {
        this(null);
    }

    public Jsr353JsonCodec(Map<String, ?> config) {
        super(DataType.varchar(), JsonStructure.class);
        this.readerFactory = Json.createReaderFactory(config);
        this.writerFactory = Json.createWriterFactory(config);
    }

    public ByteBuffer serialize(JsonStructure value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (value == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            JsonWriter writer = this.writerFactory.createWriter((OutputStream)baos);
            writer.write(value);
            ByteBuffer byteBuffer = ByteBuffer.wrap(baos.toByteArray());
            return byteBuffer;
        }
        catch (JsonException e) {
            throw new InvalidTypeException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {
                throw new InvalidTypeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public JsonStructure deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(Bytes.getArray((ByteBuffer)bytes));
        try {
            JsonReader reader = this.readerFactory.createReader((InputStream)bais);
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
        catch (JsonException e) {
            throw new InvalidTypeException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                bais.close();
            }
            catch (IOException e) {
                throw new InvalidTypeException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String format(JsonStructure value) throws InvalidTypeException {
        String json;
        if (value == null) {
            return "NULL";
        }
        StringWriter sw = new StringWriter();
        try {
            JsonWriter writer = this.writerFactory.createWriter((Writer)sw);
            writer.write(value);
            json = sw.toString();
        }
        catch (JsonException e) {
            throw new InvalidTypeException(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException e) {
                throw new InvalidTypeException(e.getMessage(), (Throwable)e);
            }
        }
        return ParseUtils.quote((String)json);
    }

    public JsonStructure parse(String value) throws InvalidTypeException {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!ParseUtils.isQuoted((String)value)) {
            throw new InvalidTypeException("JSON strings must be enclosed by single quotes");
        }
        String json = ParseUtils.unquote((String)value);
        StringReader sr = new StringReader(json);
        try {
            JsonReader reader = this.readerFactory.createReader((Reader)sr);
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
        catch (JsonException e) {
            throw new InvalidTypeException(e.getMessage(), (Throwable)e);
        }
        finally {
            sr.close();
        }
    }
}

